/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.beans.ChartData;
import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.ui.comp.PopupListener;
import app.astrosoft.ui.comp.TitleLabel;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.PlanetCellRenderer;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.window.AstrosoftWindow;
import app.astrosoft.ui.window.DefaultWindowLabelModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;

public class Chart
extends JPanel {
    private ChartData chartData;
    private List<JPanel> housePanel;
    private Dimension houseSize;
    private Dimension tableSize;
    private int rowHeight;
    private JLabel title;

    public Chart(ChartData chartData, Dimension dimension) {
        this.chartData = chartData;
        this.houseSize = new Dimension(dimension.width / 4, dimension.height / 4);
        this.tableSize = new Dimension((int)((double)this.houseSize.width * 0.8), (int)((double)this.houseSize.height * 0.8));
        this.rowHeight = this.tableSize.height / 3;
        this.housePanel = new ArrayList<JPanel>();
        this.title = new TitleLabel(chartData.getChartName());
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(dimension);
        this.addHouseTables();
        this.setVisible(true);
    }

    private void addHouseTables() {
        int n;
        Set<Rasi> set = this.chartData.getHouses();
        boolean bl = this.chartData instanceof PlanetChartData;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        Rasi rasi = this.chartData.getAscendant();
        for (Rasi rasi2 : Rasi.values()) {
            String string;
            n = rasi2.ordinal();
            JPanel jPanel = new JPanel();
            if (set.contains((Object)rasi2)) {
                Table table = this.chartData.getChartHouseTable(rasi2);
                AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(table), TableStyle.NONE);
                jPanel.add((Component)astrosoftTable, Chart.getConstrains(n));
                astrosoftTable.setRowHeight(this.rowHeight);
                astrosoftTable.setPreferredSize(this.tableSize);
                astrosoftTable.setBackground(UIConsts.getChartBackground());
                if (bl) {
                    this.decoratePlanetChart(table, astrosoftTable);
                    string = rasi2.toString(Language.ENGLISH) + ": " + rasi2.bhava(rasi);
                    astrosoftTable.setToolTipText(string);
                    toolTipManager.registerComponent(astrosoftTable);
                }
            }
            jPanel.setPreferredSize(this.houseSize);
            jPanel.setBackground(UIConsts.getChartBackground());
            jPanel.setBorder(UIConsts.getChartBorder());
            this.add((Component)jPanel, Chart.getConstrains(n));
            if (bl) {
                string = rasi2.toString(Language.ENGLISH) + ": " + rasi2.bhava(rasi);
                jPanel.setToolTipText(string);
                toolTipManager.registerComponent(jPanel);
            }
            this.housePanel.add(n, jPanel);
        }
        n = 12;
        JPanel jPanel = new JPanel();
        jPanel.add(this.title);
        this.add((Component)jPanel, Chart.getConstrains(n));
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    private void decoratePlanetChart(Table table, AstrosoftTable astrosoftTable) {
        PlanetChartData planetChartData = (PlanetChartData)this.chartData;
        boolean bl = planetChartData.highlightRetrogrades();
        EnumMap<Planet, Boolean> enumMap = planetChartData.getPlanetDir();
        for (AstrosoftTableColumn astrosoftTableColumn : table.getColumnMetaData().getVisibleColumns()) {
            astrosoftTable.setCellRenderer(new PlanetCellRenderer(astrosoftTable.getCellRenderer(astrosoftTableColumn), bl, false, enumMap), astrosoftTableColumn);
        }
        this.createPopups();
    }

    private void createPopups() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add("Rajasekar");
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.addMouseListener(popupListener);
    }

    private static GridBagConstraints getConstrains(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        switch (n) {
            case 0: {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                break;
            }
            case 1: {
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                break;
            }
            case 2: {
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                break;
            }
            case 3: {
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 1;
                break;
            }
            case 4: {
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 2;
                break;
            }
            case 5: {
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 3;
                break;
            }
            case 6: {
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 3;
                break;
            }
            case 7: {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                break;
            }
            case 8: {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                break;
            }
            case 9: {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                break;
            }
            case 10: {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                break;
            }
            case 11: {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                break;
            }
            case 12: {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("house > 12");
            }
        }
        return gridBagConstraints;
    }

    public void updateChartData(ChartData chartData) {
        this.chartData = chartData;
        this.title.setText(chartData.getChartName());
        this.removeAll();
        this.addHouseTables();
    }

    private class ChartHouseMouseListener
    extends MouseAdapter {
        AstrosoftWindow window;
        Container source;

        private ChartHouseMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Rasi rasi;
            this.source = (Container)mouseEvent.getSource();
            if (this.source instanceof JTable) {
                this.source = ((JTable)this.source).getParent();
            }
            if ((rasi = Chart.this.chartData.getAscendant()) != null) {
                int n = Rasi.ofIndex(Chart.this.housePanel.indexOf(this.source)).bhava(rasi);
                DefaultWindowLabelModel defaultWindowLabelModel = new DefaultWindowLabelModel(String.valueOf(n));
                this.window = new AstrosoftWindow(defaultWindowLabelModel);
                this.window.setPreferredSize(new Dimension(30, 20));
                Point point = this.source.getLocationOnScreen();
                Point point2 = mouseEvent.getPoint();
                point2.translate(point.x + 10, point.y - 10);
                this.window.show(point2);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }
}

