/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.util.AstrosoftFileFilter;
import app.astrosoft.util.FileOps;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class FileChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField filePath = new JTextField();
    private JButton browse = new JButton("Browse");
    private String defaultPath;
    private String title;
    private FileOps.FileDialogMode mode;
    private AstrosoftFileFilter fileFilter;

    public FileChooserPanel(Dimension dimension, String string, String string2, FileOps.FileDialogMode fileDialogMode, AstrosoftFileFilter astrosoftFileFilter) {
        this.defaultPath = string;
        this.title = string2;
        this.mode = fileDialogMode;
        this.fileFilter = astrosoftFileFilter;
        this.setLayout(new SpringLayout());
        this.setPreferredSize(dimension);
        this.addComponents();
    }

    public FileChooserPanel(Dimension dimension, String string, String string2, FileOps.FileDialogMode fileDialogMode) {
        this(dimension, string, string2, fileDialogMode, AstrosoftFileFilter.ALL_FILES);
    }

    private void addComponents() {
        if (this.defaultPath != null) {
            this.filePath.setText(this.defaultPath);
        }
        this.add(this.filePath);
        this.add(this.browse);
        SpringUtilities.makeCompactGrid(this, 1, 2, 5, 5, 5, 5);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FileOps.openFileDialog(FileChooserPanel.this, FileChooserPanel.this.mode, FileChooserPanel.this.fileFilter);
                if (string != null) {
                    FileChooserPanel.this.filePath.setText(string);
                }
            }
        });
        this.setBorder(UIConsts.getTitleBorder(this.title));
    }

    public String getFilePath() {
        return this.filePath.getText();
    }

    public void setFilePath(String string) {
        this.filePath.setText(string);
    }
}

