/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.util.AstroUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public abstract class NumeroNamePanel
extends JPanel {
    private static final Color numColor = Color.RED;
    protected static final Dimension textSize = new Dimension(50, 17);
    protected static final Dimension numSize = new Dimension(20, 17);
    protected JLabel l_blank = new JLabel(" ");
    protected JLabel l_name = new JLabel(DisplayStrings.NAME_STR.toString());
    protected JLabel l_numeroVal = new JLabel(DisplayStrings.NUMERO_VALUE_STR.toString());
    protected JLabel l_numeroNum = new JLabel(DisplayStrings.NUMERO_NUMBER_STR.toString());
    protected JTextField name = new JTextField();
    protected JTextField numeroVal = new JTextField();
    protected JTextField numeroNum = new JTextField();
    protected JButton button;
    protected KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = AstroUtil.computeNumeroVal(NumeroNamePanel.this.name.getText());
            NumeroNamePanel.this.numeroVal.setText(n == 0 ? "" : String.valueOf(n));
            int n2 = AstroUtil.toNumeroNum(n);
            NumeroNamePanel.this.numeroNum.setText(n == 0 ? "" : String.valueOf(n2));
        }
    };

    public NumeroNamePanel(final ActionListener actionListener) {
        this.setSizes();
        this.numeroNum.setForeground(numColor);
        this.numeroVal.setForeground(numColor);
        String string = this.getTitle();
        if (string != null) {
            this.button = new JButton(string);
            if (actionListener != null) {
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        actionListener.actionPerformed(actionEvent);
                    }
                });
            }
        }
    }

    protected void setSizes() {
        this.l_name.setPreferredSize(textSize);
        this.name.setPreferredSize(textSize);
        this.l_numeroVal.setPreferredSize(numSize);
        this.l_numeroNum.setPreferredSize(numSize);
        this.numeroVal.setPreferredSize(numSize);
        this.numeroNum.setPreferredSize(numSize);
    }

    protected void addComponents() {
        this.setLayout(new SpringLayout());
        this.add(SpringUtilities.makeCompactGrid(2, 1, 0, 0, 4, 4, this.l_name, this.name));
        this.addOperatorPanel1();
        this.add(SpringUtilities.makeCompactGrid(2, 1, 0, 0, 4, 4, this.l_numeroVal, this.numeroVal));
        this.addOperatorPanel2();
        this.add(SpringUtilities.makeCompactGrid(2, 1, 0, 0, 4, 4, this.l_numeroNum, this.numeroNum));
        this.add(SpringUtilities.makeCompactGrid(2, 1, 0, 0, 4, 4, this.l_blank, this.button));
        SpringUtilities.makeCompactGrid(this, 1, this.getPanelCount(), 5, 5, 10, 10);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void addOperatorPanel1() {
    }

    protected void addOperatorPanel2() {
    }

    public int getPanelCount() {
        return 4;
    }

    protected abstract String getTitle();

    @Override
    public String getName() {
        return this.name.getText();
    }

    public String getNumeroValue() {
        return this.numeroVal.getText();
    }

    public String getNumeroNumber() {
        return this.numeroNum.getText();
    }

    public void resetValues() {
        this.name.setText("");
        this.numeroVal.setText("");
        this.numeroNum.setText("");
    }

    public void setValues(String string, int n, int n2) {
        this.name.setText(string);
        this.numeroVal.setText(String.valueOf(n));
        this.numeroNum.setText(String.valueOf(n2));
    }
}

