/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.ui.comp.Pagination;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PagingPanel<E extends TableRowData>
extends JPanel {
    private static Dimension btnSize = new Dimension(20, 20);
    private static Dimension comboSize = new Dimension(50, 20);
    private AstrosoftTableModel tableModel;
    private Pagination<E> pagination;
    private JButton prevBtn = new JButton();
    private JButton nextBtn = new JButton();
    private int[] pages = new int[]{5, 10, 15, 20, 25};
    private JComboBox pageCombo = new JComboBox();
    private JComboBox showCombo = new JComboBox();
    private JLabel pageLabel = new JLabel(DisplayStrings.PAGE_STR.toString());
    private JLabel showLabel = new JLabel(DisplayStrings.SHOW_STR.toString());

    public PagingPanel(AstrosoftTableModel astrosoftTableModel, Pagination<E> pagination) {
        this.tableModel = astrosoftTableModel;
        this.pagination = pagination;
        this.addComponents();
    }

    private void addComponents() {
        this.setBackground(UIConsts.THEME_CLR);
        for (int n : this.pages) {
            this.showCombo.addItem(n);
        }
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PagingPanel.this.previousButtonClicked();
            }
        });
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PagingPanel.this.nextButtonClicked();
            }
        });
        this.pageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PagingPanel.this.pageChanged((Integer)itemEvent.getItem());
            }
        });
        this.showCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PagingPanel.this.pageLengthChanged((Integer)itemEvent.getItem());
            }
        });
        this.showCombo.setSelectedItem(this.pagination.getPageLength());
        this.prevBtn.setIcon(UIUtil.createImageIcon("prev"));
        this.nextBtn.setIcon(UIUtil.createImageIcon("next"));
        this.nextBtn.setBorder(BorderFactory.createEtchedBorder());
        this.prevBtn.setBorder(BorderFactory.createEtchedBorder());
        this.nextBtn.setPreferredSize(btnSize);
        this.prevBtn.setPreferredSize(btnSize);
        this.pageCombo.setPreferredSize(comboSize);
        this.add(this.showLabel);
        this.add(this.showCombo);
        this.add(this.prevBtn);
        this.add(this.pageLabel);
        this.add(this.pageCombo);
        this.add(this.nextBtn);
        this.nextButtonClicked();
        this.prevBtn.setEnabled(false);
    }

    protected void pageLengthChanged(Integer n) {
        this.pagination.setPageLength(n);
        this.nextButtonClicked();
        this.prevBtn.setEnabled(false);
    }

    protected void pageChanged(int n) {
        this.tableModel.updateData(this.pagination.getPage(n));
        this.adjustControls();
    }

    private void nextButtonClicked() {
        this.tableModel.updateData(this.pagination.getNextPage());
        if (this.pageCombo.getItemCount() < this.pagination.getTotalPages()) {
            this.pageCombo.addItem(this.pagination.getTotalPages());
        }
        this.pageCombo.setSelectedItem(this.pagination.getCurrentPage());
        this.adjustControls();
    }

    private void previousButtonClicked() {
        this.tableModel.updateData(this.pagination.getPreviousPage());
        this.pageCombo.setSelectedItem(this.pagination.getCurrentPage());
        this.adjustControls();
    }

    public void setPagination(Pagination<E> pagination) {
        this.pagination = pagination;
        this.nextButtonClicked();
    }

    private void adjustControls() {
        if (this.pagination.isFirstPage()) {
            this.prevBtn.setEnabled(false);
        } else {
            this.prevBtn.setEnabled(true);
        }
        if (this.pagination.isLastPage()) {
            this.nextBtn.setEnabled(false);
        } else {
            this.nextBtn.setEnabled(true);
        }
    }
}

