/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.beans.Place;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.util.AstrosoftTimeZone;
import app.astrosoft.util.PlaceFinder;
import app.astrosoft.util.Timer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class PlaceChooser
extends JPanel {
    private JLabel l_timezone = new JLabel("Time Zone");
    private JLabel l_place = new JLabel("Place");
    private JLabel l_latitude = new JLabel("Latitude");
    private JLabel l_longitude = new JLabel("Longitude");
    private JButton searchButton = new JButton();
    private JTextField latitude_deg = new JTextField(4);
    private JTextField latitude_min = new JTextField(4);
    private JTextField longitude_deg = new JTextField(4);
    private JTextField longitude_min = new JTextField(4);
    private JComboBox placeCombo;
    private final JComboBox timeZoneCombo;
    private JComboBox dir_ns;
    private JComboBox dir_ew;
    private String city;
    private String state;
    private String country;
    private boolean showTitle;
    private Dimension size;
    Timer t;

    public PlaceChooser(Dimension dimension, boolean bl) {
        this.showTitle = bl;
        this.timeZoneCombo = new JComboBox<AstrosoftTimeZone>(AstrosoftTimeZone.availableTimeZones());
        this.initComponents();
        this.addComponents();
        this.size = dimension;
        this.setPreferredSize(dimension);
    }

    private void addComponents() {
        JPanel jPanel = new JPanel(new SpringLayout());
        this.searchButton.setPreferredSize(UIConsts.BUTTON_ICON_SIZE);
        jPanel.add(this.placeCombo);
        jPanel.add(this.searchButton);
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.add(this.latitude_deg);
        jPanel2.add(this.latitude_min);
        jPanel2.add(this.dir_ns);
        JPanel jPanel3 = new JPanel(new SpringLayout());
        jPanel3.add(this.longitude_deg);
        jPanel3.add(this.longitude_min);
        jPanel3.add(this.dir_ew);
        SpringUtilities.makeCompactGrid(jPanel, 1, 2, 5, 5, 5, 5);
        SpringUtilities.makeCompactGrid(jPanel2, 1, 3, 5, 5, 10, 10);
        SpringUtilities.makeCompactGrid(jPanel3, 1, 3, 5, 5, 10, 10);
        this.add(this.l_place);
        this.add(jPanel);
        this.add(this.l_latitude);
        this.add(jPanel2);
        this.add(this.l_longitude);
        this.add(jPanel3);
        this.add(this.l_timezone);
        this.add(this.timeZoneCombo);
        SpringUtilities.makeCompactGrid(this, 4, 2, 5, 5, 10, 10);
    }

    public PlaceChooser() {
        this(new Dimension(350, 200), true);
    }

    private void initComponents() {
        this.placeCombo = new JComboBox();
        this.placeCombo.setEditable(true);
        this.dir_ew = new JComboBox<Object>(Place.Direction.EW().toArray());
        this.dir_ns = new JComboBox<Object>(Place.Direction.NS().toArray());
        if (this.showTitle) {
            this.setBorder(UIConsts.getTitleBorder("Place"));
        }
        this.setLayout(new SpringLayout());
        Place place = AstroSoft.getPreferences().getPlace();
        this.addPlaces(new Place[]{place});
        this.searchButton.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlaceChooser.this.searchClicked();
            }
        };
        this.searchButton.addActionListener(actionListener);
        ImageIcon imageIcon = UIUtil.createImageIcon("Loc_Search");
        this.searchButton.setIcon(imageIcon);
        this.placeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = itemEvent.getItem();
                if (object instanceof Place) {
                    PlaceChooser.this.setSelectedPlace((Place)object);
                }
            }
        });
        this.placeCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)PlaceChooser.this.placeCombo.getEditor().getEditorComponent()).getText();
                if (string.length() > 0) {
                    PlaceChooser.this.searchButton.setEnabled(true);
                } else {
                    PlaceChooser.this.searchButton.setEnabled(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PlaceChooser.this.searchClicked();
                }
            }
        });
    }

    public Place getSelectedPlace() {
        Place.Location location = new Place.Location(this.latitude_deg.getText(), this.latitude_min.getText(), (Place.Direction)((Object)this.dir_ns.getSelectedItem()));
        Place.Location location2 = new Place.Location(this.longitude_deg.getText(), this.longitude_min.getText(), (Place.Direction)((Object)this.dir_ew.getSelectedItem()));
        String string = ((AstrosoftTimeZone)this.timeZoneCombo.getSelectedItem()).id();
        String[] stringArray = this.placeCombo.getSelectedItem().toString().split(",");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 1) {
            string2 = stringArray[1];
            if (stringArray.length > 2) {
                string3 = stringArray[2];
            }
        }
        Place place = new Place(stringArray[0], string2, string3, location, location2, string);
        return place;
    }

    public void setSelectedPlace(final Place place) {
        this.placeCombo.setSelectedItem(place);
        this.city = place.city();
        this.state = place.state();
        this.country = place.country();
        Place.Location location = place.latitudeLocation();
        Place.Location location2 = place.longitudeLocation();
        this.latitude_deg.setText(String.valueOf(location.deg()));
        this.latitude_min.setText(String.valueOf(location.min()));
        this.dir_ns.setSelectedItem((Object)location.dir());
        this.longitude_deg.setText(String.valueOf(location2.deg()));
        this.longitude_min.setText(String.valueOf(location2.min()));
        this.dir_ew.setSelectedItem((Object)location2.dir());
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlaceChooser.this.timeZoneCombo.setSelectedItem(place.astrosoftTimeZone());
                System.out.println("done");
            }
        }).start();
    }

    private void addPlaces(Place[] placeArray) {
        this.addPlaces(Arrays.asList(placeArray));
    }

    public void addPlaces(List<Place> list) {
        this.placeCombo.removeAllItems();
        for (Place place : list) {
            this.placeCombo.addItem(place);
        }
        if (list.size() > 0) {
            this.setSelectedPlace(list.get(0));
        }
    }

    private void searchClicked() {
        Object object = this.placeCombo.getSelectedItem();
        if (object != null) {
            List<Place> list = PlaceFinder.findPlace(object.toString());
            this.addPlaces(list);
            this.placeCombo.showPopup();
        }
    }
}

