/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.ui.comp.ProgressListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressBarPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(ProgressBarPanel.class.getName());
    private JProgressBar pbar;
    private FutureTask<Object> task;
    private String taskName;
    private ProgressListener listener;

    public ProgressBarPanel(Dimension dimension, FutureTask<Object> futureTask, String string, ProgressListener progressListener) {
        this.task = futureTask;
        this.taskName = string;
        this.listener = progressListener;
        this.addComponents();
        this.setPreferredSize(dimension);
        new Worker().execute();
    }

    private void addComponents() {
        this.setLayout(new BorderLayout());
        this.pbar = new JProgressBar();
        this.pbar.setIndeterminate(true);
        this.pbar.setStringPainted(true);
        this.pbar.setString(this.taskName + "...");
        this.add("Center", this.pbar);
    }

    private void taskCompleted() {
        this.pbar.setString("Completed!");
        this.pbar.setIndeterminate(false);
        this.listener.completed();
    }

    private class Worker
    extends SwingWorker<Void, Void> {
        private Worker() {
        }

        @Override
        public Void doInBackground() {
            try {
                ProgressBarPanel.this.task.get();
                ProgressBarPanel.this.taskCompleted();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Exception in " + ProgressBarPanel.this.taskName, exception);
            }
            return null;
        }
    }
}

