/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Rasi;
import app.astrosoft.ui.util.LocationGenerator;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class RasiNakshathraChooser
extends JPanel {
    private Dimension compSize;
    private String title;
    private Point origin;
    private Dimension labelSize;
    private Dimension comboSize;
    private int hgap;
    private int vgap;
    private JComboBox rasiCombo;
    private JComboBox nakCombo;
    private Font font = UIUtil.getFont(1, 10);

    public RasiNakshathraChooser() {
        this(null, new Dimension(300, 100));
    }

    public RasiNakshathraChooser(String string) {
        this(string, new Dimension(300, 100));
    }

    public RasiNakshathraChooser(Dimension dimension) {
        this(null, dimension);
    }

    public RasiNakshathraChooser(String string, Dimension dimension) {
        this.title = string;
        this.compSize = dimension;
        this.initComponents();
        this.setPreferredSize(dimension);
    }

    public void initComponents() {
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.rasiCombo = new JComboBox<Rasi>(Rasi.values());
        this.nakCombo = new JComboBox();
        this.populateNakCombo(Rasi.Mesha);
        this.rasiCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RasiNakshathraChooser.this.populateNakCombo((Rasi)((Object)RasiNakshathraChooser.this.rasiCombo.getSelectedItem()));
            }
        });
        this.rasiCombo.setFont(this.font);
        this.nakCombo.setFont(this.font);
        this.showPanel();
    }

    private void showPanel() {
        this.origin = new Point(this.compSize.width * 10 / 100, this.compSize.height * 20 / 100);
        this.hgap = 0;
        this.vgap = this.compSize.height * 60 / 100 - 40;
        this.labelSize = new Dimension(this.compSize.width * 80 * 40 / 10000, 20);
        this.comboSize = new Dimension(this.compSize.width * 80 * 60 / 10000, 20);
        LocationGenerator locationGenerator = new LocationGenerator(this.origin, this.labelSize.width + this.hgap, this.labelSize.height + this.vgap);
        JLabel jLabel = new JLabel(DisplayStrings.RASI_STR.toString(Language.ENGLISH));
        JLabel jLabel2 = new JLabel(DisplayStrings.NAK_STR.toString(Language.ENGLISH));
        this.add((Component)jLabel, new AbsoluteConstraints(locationGenerator.getNextRow(), this.labelSize));
        this.add((Component)this.rasiCombo, new AbsoluteConstraints(locationGenerator.getNextColumn(), this.comboSize));
        this.add((Component)jLabel2, new AbsoluteConstraints(locationGenerator.getNextRow(), this.labelSize));
        this.add((Component)this.nakCombo, new AbsoluteConstraints(locationGenerator.getNextColumn(), this.comboSize));
        if (this.title != null) {
            this.setBorder(UIConsts.getTitleBorder(this.title));
        }
        this.setVisible(true);
    }

    private void populateNakCombo(Rasi rasi) {
        this.nakCombo.removeAllItems();
        EnumSet<Nakshathra> enumSet = Nakshathra.ofRasi(rasi);
        for (Nakshathra nakshathra : enumSet) {
            this.nakCombo.addItem(nakshathra);
        }
    }

    public Rasi getSelectedRasi() {
        return (Rasi)((Object)this.rasiCombo.getSelectedItem());
    }

    public Nakshathra getSelectedNakshathra() {
        return (Nakshathra)((Object)this.nakCombo.getSelectedItem());
    }

    public void setSelectedRasiNakshthra(Rasi rasi, Nakshathra nakshathra) {
        this.rasiCombo.setSelectedItem((Object)rasi);
        this.nakCombo.setSelectedItem((Object)nakshathra);
    }
}

