/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.Varga;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class VargaChartPanel
extends JPanel {
    private PlanetaryInfo planetaryInfo;
    private Dimension panelSize;
    private Dimension comboSize = new Dimension(200, 20);
    private JComboBox vargaCombo;
    private Chart chart;

    public VargaChartPanel(PlanetaryInfo planetaryInfo, Dimension dimension) {
        this.planetaryInfo = planetaryInfo;
        this.panelSize = dimension;
        this.vargaCombo = new JComboBox<Varga>(Varga.values());
        this.vargaCombo.setFont(UIUtil.getFont("Tahoma", 0, 11));
        this.vargaCombo.setSelectedItem((Object)Varga.Rasi);
        this.vargaCombo.setPreferredSize(this.comboSize);
        this.vargaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VargaChartPanel.this.vargaChanged((Varga)((Object)VargaChartPanel.this.vargaCombo.getSelectedItem()));
            }
        });
        this.setLayout(new BorderLayout());
        this.vargaChanged(Varga.Rasi);
        JPanel jPanel = new JPanel();
        jPanel.add(this.vargaCombo);
        this.add((Component)jPanel, "First");
        this.add((Component)new JPanel(), "Last");
    }

    private void vargaChanged(Varga varga) {
        if (this.chart != null) {
            this.chart.updateChartData(new PlanetChartData(varga, this.planetaryInfo));
        } else {
            this.chart = new Chart(new PlanetChartData(varga, this.planetaryInfo), this.panelSize);
            this.add((Component)this.chart, "Center");
        }
    }
}

