/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.beans.BirthData;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Rasi;
import app.astrosoft.core.Horoscope;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.BirthDataPanel;
import app.astrosoft.ui.comp.RasiNakshathraChooser;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CompactibilityInputDialog
extends AstrosoftDialog {
    private static final Dimension dlgSize = new Dimension(660, 420);
    private static final Dimension panelSize = new Dimension(CompactibilityInputDialog.dlgSize.width - 10, CompactibilityInputDialog.dlgSize.height);
    private static final Dimension couplePanelSize = new Dimension(CompactibilityInputDialog.panelSize.width / 2, CompactibilityInputDialog.panelSize.height - 90);
    private JTabbedPane tabbedPane;
    private BirthDataPanel boyDataPanel;
    private BirthDataPanel girlDataPanel;
    private RasiNakshathraChooser bRasiNakChooser;
    private RasiNakshathraChooser gRasiNakChooser;
    private JButton horOkButton = new JButton(DisplayStrings.OK_STR.toString());
    private JButton starOkButton = new JButton(DisplayStrings.OK_STR.toString());
    private JTextField boyName = new JTextField(14);
    private JTextField girlName = new JTextField(14);

    public CompactibilityInputDialog(AstroSoft astroSoft) {
        super(astroSoft, "Enter Birth Details", dlgSize);
        this.initComponents();
        this.addComponents();
        this.setVisible(true);
    }

    public CompactibilityInputDialog(AstroSoft astroSoft, String string, String string2, Rasi rasi, Rasi rasi2, Nakshathra nakshathra, Nakshathra nakshathra2) {
        this(astroSoft);
        this.boyName.setText(string);
        this.girlName.setText(string2);
        this.bRasiNakChooser.setSelectedRasiNakshthra(rasi, nakshathra);
        this.gRasiNakChooser.setSelectedRasiNakshthra(rasi2, nakshathra2);
        this.tabbedPane.setSelectedIndex(1);
    }

    public CompactibilityInputDialog(AstroSoft astroSoft, BirthData birthData, BirthData birthData2) {
        this(astroSoft);
        this.boyDataPanel.setBirthData(birthData);
        this.girlDataPanel.setBirthData(birthData2);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.horOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Horoscope horoscope = new Horoscope(CompactibilityInputDialog.this.boyDataPanel.getBirthData());
                Horoscope horoscope2 = new Horoscope(CompactibilityInputDialog.this.girlDataPanel.getBirthData());
                CompactibilityInputDialog.this.parent.displayCompactibility(horoscope, horoscope2);
                CompactibilityInputDialog.this.closeDialog();
            }
        });
        this.starOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rasi rasi = CompactibilityInputDialog.this.bRasiNakChooser.getSelectedRasi();
                Rasi rasi2 = CompactibilityInputDialog.this.gRasiNakChooser.getSelectedRasi();
                Nakshathra nakshathra = CompactibilityInputDialog.this.bRasiNakChooser.getSelectedNakshathra();
                Nakshathra nakshathra2 = CompactibilityInputDialog.this.gRasiNakChooser.getSelectedNakshathra();
                CompactibilityInputDialog.this.parent.displayCompactibility(CompactibilityInputDialog.this.boyName.getText(), CompactibilityInputDialog.this.girlName.getText(), rasi, rasi2, nakshathra, nakshathra2);
                CompactibilityInputDialog.this.closeDialog();
            }
        });
    }

    private void addComponents() {
        this.dlgPanel.setLayout(new FlowLayout());
        this.tabbedPane.add(DisplayStrings.HOROSCOPE_STR.toString(), this.createHoroscopePanel());
        this.tabbedPane.add(DisplayStrings.STAR_STR.toString(), this.createStarPanel());
        this.dlgPanel.add(this.tabbedPane);
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
    }

    private JPanel createHoroscopePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.boyDataPanel = new BirthDataPanel(couplePanelSize, DisplayStrings.BOY_DATA_STR.toString());
        this.girlDataPanel = new BirthDataPanel(couplePanelSize, DisplayStrings.GIRL_DATA_STR.toString());
        jPanel.add((Component)this.boyDataPanel, "West");
        jPanel.add((Component)this.girlDataPanel, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.horOkButton);
        jPanel.add((Component)jPanel2, "Last");
        UIUtil.setPanelBackground(jPanel, UIConsts.THEME_CLR);
        return jPanel;
    }

    private JPanel createStarPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.bRasiNakChooser = new RasiNakshathraChooser(new Dimension(CompactibilityInputDialog.couplePanelSize.width - 12, CompactibilityInputDialog.couplePanelSize.height - 150));
        this.gRasiNakChooser = new RasiNakshathraChooser(new Dimension(CompactibilityInputDialog.couplePanelSize.width - 12, CompactibilityInputDialog.couplePanelSize.height - 150));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.add(new JLabel("  " + DisplayStrings.NAME_STR.toString(Language.ENGLISH) + "                      "));
        jPanel4.add(this.boyName);
        jPanel2.add((Component)jPanel4, "First");
        jPanel2.add((Component)this.bRasiNakChooser, "Center");
        jPanel5.add(new JLabel("  " + DisplayStrings.NAME_STR.toString(Language.ENGLISH) + "                      "));
        jPanel5.add(this.girlName);
        jPanel3.add((Component)jPanel5, "First");
        jPanel3.add((Component)this.gRasiNakChooser, "Center");
        jPanel2.setBorder(UIConsts.getTitleBorder(DisplayStrings.BOY_DATA_STR));
        jPanel3.setBorder(UIConsts.getTitleBorder(DisplayStrings.GIRL_DATA_STR));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.starOkButton);
        jPanel.add((Component)jPanel6, "Last");
        UIUtil.setPanelBackground(jPanel, UIConsts.THEME_CLR);
        return jPanel;
    }
}

