/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.exception.AstrosoftException;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.FileChooserPanel;
import app.astrosoft.ui.comp.ProgressBarPanel;
import app.astrosoft.ui.comp.ProgressListener;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.util.FileOps;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.FutureTask;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class ExportDialog
extends AstrosoftDialog {
    private static final Dimension dlgSize = new Dimension(400, 260);
    private static final Dimension acrobatSize = new Dimension(ExportDialog.dlgSize.width - 100, 50);
    private static final Dimension progressSize = new Dimension(ExportDialog.dlgSize.width - 100, 15);
    private FutureTask<Object> task;
    private JButton open = new JButton("Open");
    private JButton close = new JButton("Close");
    private String outputFile;
    private FileChooserPanel acrobatPanel;

    public ExportDialog(AstroSoft astroSoft, String string, FutureTask<Object> futureTask, String string2) {
        super(astroSoft, string, dlgSize);
        this.task = futureTask;
        this.outputFile = string2;
        this.addComponents();
        this.setVisible(true);
    }

    private void addComponents() {
        this.dlgPanel.setLayout(new SpringLayout());
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void completed() {
                ExportDialog.this.exportCompleted();
            }
        };
        ProgressBarPanel progressBarPanel = new ProgressBarPanel(progressSize, this.task, "Exporting", progressListener);
        this.dlgPanel.add(progressBarPanel);
        this.acrobatPanel = new FileChooserPanel(acrobatSize, AstroSoft.getPreferences().getAcrobatExecutable(), "Acrobat Executable", FileOps.FileDialogMode.OPEN);
        this.dlgPanel.add(this.acrobatPanel);
        JPanel jPanel = new JPanel();
        jPanel.add(this.open);
        jPanel.add(this.close);
        this.dlgPanel.add(jPanel);
        this.open.setEnabled(false);
        this.close.setEnabled(false);
        SpringUtilities.makeCompactGrid(this.dlgPanel, 3, 1, 30, 30, 30, 30);
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
        this.addListeners();
    }

    private void addListeners() {
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.openClicked();
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.dispose();
            }
        });
    }

    protected void exportCompleted() {
        this.open.setEnabled(true);
        this.close.setEnabled(true);
    }

    protected void openClicked() {
        try {
            AstroSoft.getPreferences().setAcrobatExecutable(this.acrobatPanel.getFilePath());
            FileOps.openDocument(this.outputFile);
        }
        catch (AstrosoftException astrosoftException) {
            OptionDialog.showDialog(astrosoftException.getMessage(), 0);
        }
    }
}

