/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.core.Muhurtha;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.RasiNakshathraChooser;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.util.LocationGenerator;
import app.astrosoft.ui.util.UIConsts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MuhurthaInput
extends AstrosoftDialog {
    private static final Dimension dlgSize = new Dimension(300, 350);
    private static final Dimension nakChooserSize = new Dimension(MuhurthaInput.dlgSize.width - 60, 100);
    private static final Point origin = new Point(30, 30);
    private static final Rectangle nakPanelLoc = new Rectangle(new Point(30, 30), nakChooserSize);
    private static final Rectangle filterPanelLoc = new Rectangle(MuhurthaInput.nakPanelLoc.x, MuhurthaInput.nakPanelLoc.y + MuhurthaInput.nakPanelLoc.height + 20, MuhurthaInput.nakPanelLoc.width, MuhurthaInput.nakPanelLoc.height);
    private JCheckBox chandraFilter;
    private JCheckBox nakFilter;
    private JButton okButton;
    private RasiNakshathraChooser nakPanel;

    public MuhurthaInput(AstroSoft astroSoft) {
        super(astroSoft, "Muhurtha For", dlgSize);
        this.initComponents();
    }

    public void initComponents() {
        this.nakPanel = new RasiNakshathraChooser(DisplayStrings.NAK_STR.toString(Language.ENGLISH), nakChooserSize);
        JPanel jPanel = new JPanel((LayoutManager)new AbsoluteLayout());
        this.chandraFilter = new JCheckBox(DisplayStrings.FILTER_BY_CHANDRA_STR.toString(), true);
        this.nakFilter = new JCheckBox(DisplayStrings.FILTER_BY_MUHURTHA_STR.toString());
        this.okButton = new JButton("Ok");
        jPanel.setBorder(UIConsts.getTitleBorder(DisplayStrings.FILTER_STR.toString()));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuhurthaInput.this.okButtonClicked();
            }
        });
        LocationGenerator locationGenerator = new LocationGenerator(origin, 0, 20);
        jPanel.add((Component)this.chandraFilter, new AbsoluteConstraints(locationGenerator.getNextRow(), new Dimension(200, 20)));
        jPanel.add((Component)this.nakFilter, new AbsoluteConstraints(locationGenerator.getNextRow(), new Dimension(200, 20)));
        this.dlgPanel.add((Component)this.nakPanel, new AbsoluteConstraints(nakPanelLoc.getLocation(), nakPanelLoc.getSize()));
        this.dlgPanel.add((Component)jPanel, new AbsoluteConstraints(filterPanelLoc.getLocation(), filterPanelLoc.getSize()));
        Dimension dimension = new Dimension(60, 20);
        this.dlgPanel.add((Component)this.okButton, new AbsoluteConstraints(new Point((MuhurthaInput.dlgSize.width - dimension.width) / 2, 270), dimension));
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
        this.setVisible(true);
    }

    private void okButtonClicked() {
        Muhurtha muhurtha = new Muhurtha(AstroSoft.today, this.nakPanel.getSelectedRasi(), this.nakPanel.getSelectedNakshathra(), this.chandraFilter.isSelected(), this.nakFilter.isSelected(), 2);
        this.parent.displayMuhurtha(muhurtha);
        this.closeDialog();
    }
}

