/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.PlaceChooser;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.util.UIConsts;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class PlaceOptionDialog
extends AstrosoftDialog {
    private static final Dimension dlgSize = new Dimension(400, 280);
    private JButton okButton = new JButton(DisplayStrings.OK_STR.toString());
    private PlaceChooser placeChooser;

    public PlaceOptionDialog(AstroSoft astroSoft) {
        super(astroSoft, "Set Default Location", dlgSize);
        this.initComponents();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlaceOptionDialog.this.okClicked();
            }
        });
        this.setVisible(true);
    }

    private void initComponents() {
        this.dlgPanel.setLayout(new FlowLayout());
        this.placeChooser = new PlaceChooser(new Dimension(PlaceOptionDialog.dlgSize.width - 50, PlaceOptionDialog.dlgSize.height - 80), true);
        this.dlgPanel.add(this.placeChooser);
        this.dlgPanel.add(this.okButton);
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
    }

    private void okClicked() {
        try {
            AstroSoft.getPreferences().setPlace(this.placeChooser.getSelectedPlace());
            this.closeDialog();
        }
        catch (Exception exception) {
            OptionDialog.showDialog("Place Enter Valid Latitude/Longitude ", 0);
        }
    }
}

