/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.core.PanchangList;
import app.astrosoft.exception.AstrosoftException;
import app.astrosoft.export.AstrosoftExporter;
import app.astrosoft.export.Exportable;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.CalendarSpinner;
import app.astrosoft.ui.comp.DateListener;
import app.astrosoft.ui.comp.FileChooserPanel;
import app.astrosoft.ui.comp.ProgressBarPanel;
import app.astrosoft.ui.comp.ProgressListener;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.AstrosoftFileFilter;
import app.astrosoft.util.FileOps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SpringLayout;

public class PrintDialog
extends AstrosoftDialog {
    private static final Logger log = Logger.getLogger(PrintDialog.class.getName());
    private static final Dimension dlgSize = new Dimension(440, 270);
    private static final Dimension extDlgSize = new Dimension(440, 380);
    private static final Dimension fileChooserSize = new Dimension(PrintDialog.dlgSize.width - 60, 60);
    private static final Dimension acrobatSize = new Dimension(PrintDialog.dlgSize.width - 60, 60);
    private static final Dimension progressSize = new Dimension(PrintDialog.dlgSize.width - 60, 25);
    private static final Dimension printPanelSize = new Dimension(PrintDialog.dlgSize.width - 60, PrintDialog.dlgSize.height - 60);
    private static final String defaultPath = AstroSoft.getPreferences().getAstrosoftFilesDir();
    private static SimpleDateFormat df = new SimpleDateFormat("MMM");
    private FileChooserPanel acrobatPanel;
    private FileChooserPanel outputFileChooser;
    JPanel printPanel;
    private JComboBox printTypes;
    private JButton print;
    private JButton cancel;
    private Window panInputWindow;
    private boolean windowShown = false;
    private JCheckBox fullYear = new JCheckBox("Full Year", false);
    private CalendarSpinner spinner;
    private JButton arrow = new JButton(UIUtil.createImageIcon("calendar"));

    public PrintDialog(AstroSoft astroSoft) {
        super(astroSoft, "Print ", dlgSize);
        this.addComponents();
        this.setVisible(true);
    }

    private void addComponents() {
        this.dlgPanel.setLayout(new FlowLayout());
        this.printPanel = this.createPrintPanel();
        this.dlgPanel.add(this.printPanel);
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
        if (new File(this.outputFileChooser.getFilePath()).exists()) {
            this.printCompleted();
        }
    }

    private JPanel createPrintPanel() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setPreferredSize(printPanelSize);
        jPanel.add(this.createPrintTypePanel());
        boolean bl = ((AstrosoftExporter.Type)((Object)this.printTypes.getSelectedItem())).equals((Object)AstrosoftExporter.Type.Panchang);
        if (bl) {
            this.arrow.setEnabled(true);
        } else {
            this.arrow.setEnabled(false);
        }
        this.outputFileChooser = new FileChooserPanel(fileChooserSize, this.getDefaultFile(), "Output File ", FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.PDF_EXTN);
        jPanel.add(this.outputFileChooser);
        JPanel jPanel2 = new JPanel();
        this.print = new JButton("Print");
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.printClicked();
            }
        });
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this.closeListener);
        jPanel2.add(this.print);
        jPanel2.add(this.cancel);
        jPanel.add(jPanel2);
        SpringUtilities.makeCompactGrid(jPanel, 3, 1, 10, 10, 10, 23);
        jPanel.setBorder(UIConsts.getTitleBorder("Print"));
        return jPanel;
    }

    protected void printClicked() {
        Serializable serializable;
        Object object;
        String string = this.outputFileChooser.getFilePath();
        if (string == null || string.isEmpty()) {
            OptionDialog.showDialog("Please choose valid file ", 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.print.setEnabled(false);
        this.cancel.setEnabled(false);
        AstrosoftExporter.Type type = (AstrosoftExporter.Type)((Object)this.printTypes.getSelectedItem());
        FutureTask<Object> futureTask = null;
        if (type.equals((Object)AstrosoftExporter.Type.Horosocope)) {
            futureTask = AstrosoftExporter.export2Pdf(AstrosoftExporter.Type.Horosocope, this.parent.getHoroscope(), string);
        } else if (type.equals((Object)AstrosoftExporter.Type.Compactibility)) {
            futureTask = AstrosoftExporter.export2Pdf(AstrosoftExporter.Type.Compactibility, this.parent.getCompactibility(), string);
        } else if (type.equals((Object)AstrosoftExporter.Type.Panchang)) {
            this.closePanInputWindow();
            object = null;
            serializable = this.spinner != null ? AstroUtil.getCalendar(this.spinner.getSelectedDate()) : AstroUtil.getCalendar();
            object = this.fullYear.isSelected() ? new PanchangList(((Calendar)serializable).get(1)) : new PanchangList(((Calendar)serializable).get(1), ((Calendar)serializable).get(2));
            futureTask = AstrosoftExporter.export2Pdf(type, (Exportable)object, string);
        }
        object = new ProgressListener(){

            @Override
            public void completed() {
                PrintDialog.this.printCompleted();
            }
        };
        serializable = new ProgressBarPanel(progressSize, futureTask, "Printing", (ProgressListener)object);
        this.refresh((JPanel)serializable);
    }

    protected void printCompleted() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.print.setEnabled(true);
        this.cancel.setEnabled(true);
        JPanel jPanel = new JPanel(new SpringLayout());
        this.acrobatPanel = new FileChooserPanel(acrobatSize, AstroSoft.getPreferences().getAcrobatExecutable(), "Acrobat Executable", FileOps.FileDialogMode.OPEN);
        jPanel.add(this.acrobatPanel);
        JButton jButton = new JButton("Open");
        JButton jButton2 = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.openClicked();
            }
        });
        jButton2.addActionListener(this.closeListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        SpringUtilities.makeCompactGrid(jPanel, 2, 1, 10, 10, 10, 10);
        this.refresh(jPanel);
    }

    private void openClicked() {
        try {
            AstroSoft.getPreferences().setAcrobatExecutable(this.acrobatPanel.getFilePath());
            FileOps.openDocument(this.outputFileChooser.getFilePath());
        }
        catch (AstrosoftException astrosoftException) {
            OptionDialog.showDialog(astrosoftException.getMessage(), 0);
        }
    }

    private JPanel createPrintTypePanel() {
        JPanel jPanel = new JPanel(new SpringLayout());
        this.printTypes = new JComboBox();
        this.printTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (((AstrosoftExporter.Type)((Object)PrintDialog.this.printTypes.getSelectedItem())).equals((Object)AstrosoftExporter.Type.Panchang)) {
                    PrintDialog.this.arrow.setEnabled(true);
                } else {
                    PrintDialog.this.arrow.setEnabled(false);
                }
                if (PrintDialog.this.outputFileChooser != null) {
                    String string = PrintDialog.this.getDefaultFile();
                    PrintDialog.this.outputFileChooser.setFilePath(string);
                    if (new File(string).exists()) {
                        PrintDialog.this.printCompleted();
                    } else {
                        PrintDialog.this.refresh();
                    }
                }
            }
        });
        if (this.parent.getHoroscope() != null) {
            this.printTypes.addItem(AstrosoftExporter.Type.Horosocope);
        }
        if (this.parent.getCompactibility() != null) {
            this.printTypes.addItem(AstrosoftExporter.Type.Compactibility);
        }
        this.printTypes.addItem(AstrosoftExporter.Type.Panchang);
        this.arrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.arrowClicked();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.printTypes, "Center");
        jPanel2.add((Component)this.arrow, "East");
        jPanel.add(new JLabel("Print "));
        jPanel.add(jPanel2);
        SpringUtilities.makeCompactGrid(jPanel, 1, 2, 0, 0, 5, 5);
        return jPanel;
    }

    protected void arrowClicked() {
        if (!this.windowShown) {
            this.panInputWindow = this.createPanchangInputWindow();
            UIUtil.setWindowLocation(this.panInputWindow, this.printTypes);
            this.panInputWindow.setVisible(true);
            this.windowShown = true;
        } else {
            this.closePanInputWindow();
        }
    }

    private void closePanInputWindow() {
        if (this.panInputWindow != null) {
            this.panInputWindow.dispose();
            this.windowShown = false;
        }
    }

    private void refresh(JPanel jPanel) {
        this.dlgPanel.removeAll();
        this.dlgPanel.add(this.printPanel);
        if (jPanel != null) {
            this.dlgPanel.add(jPanel);
            this.resetSize(extDlgSize);
        } else {
            this.resetSize(dlgSize);
        }
        this.setBackground();
        this.repaint();
        this.setVisible(true);
    }

    private void refresh() {
        this.refresh(null);
    }

    private String getDefaultFile() {
        AstrosoftExporter.Type type = (AstrosoftExporter.Type)((Object)this.printTypes.getSelectedItem());
        if (type != null) {
            if (type.equals((Object)AstrosoftExporter.Type.Horosocope)) {
                return this.parent.getHoroscope().createDocumentName();
            }
            if (type.equals((Object)AstrosoftExporter.Type.Compactibility)) {
                return this.parent.getCompactibility().createDocumentName();
            }
            if (type.equals((Object)AstrosoftExporter.Type.Panchang)) {
                return this.getPanchangOutputFile(null);
            }
        }
        return null;
    }

    private Window createPanchangInputWindow() {
        JWindow jWindow = new JWindow(this);
        Container container = jWindow.getContentPane();
        container.setLayout(new BorderLayout());
        this.spinner = new CalendarSpinner("MMM yyyy");
        this.spinner.addDateListener(new DateListener(){

            @Override
            public void dateChanged(Date date) {
                PrintDialog.this.outputFileChooser.setFilePath(PrintDialog.this.getPanchangOutputFile(date));
            }
        });
        JPanel jPanel = this.spinner.getChooser();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.add(this.fullYear);
        jPanel2.setBackground(UIConsts.CAL_COMBO_BACKGROUND);
        jPanel2.setBorder(BorderFactory.createEtchedBorder(1));
        container.add((Component)jPanel2, "Center");
        jWindow.pack();
        this.fullYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.outputFileChooser.setFilePath(PrintDialog.this.getPanchangOutputFile(PrintDialog.this.spinner.getSelectedDate()));
            }
        });
        return jWindow;
    }

    private String getPanchangOutputFile(Date date) {
        Calendar calendar;
        StringBuilder stringBuilder = new StringBuilder(defaultPath);
        stringBuilder.append("Panchang");
        Calendar calendar2 = calendar = date != null ? AstroUtil.getCalendar(date) : AstroUtil.getCalendar();
        if (!this.fullYear.isSelected()) {
            stringBuilder.append("_");
            stringBuilder.append(df.format(calendar.getTime()));
        }
        stringBuilder.append("_");
        stringBuilder.append(calendar.get(1));
        stringBuilder.append(".pdf");
        return stringBuilder.toString();
    }
}

