/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.dlg;

import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.CalendarChooser;
import app.astrosoft.ui.comp.DateListener;
import app.astrosoft.ui.dlg.AstrosoftDialog;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class TimeInputDialog
extends AstrosoftDialog {
    private static final Dimension dlgSize = new Dimension(300, 180);
    private static final Dimension panelSize = new Dimension((int)((double)TimeInputDialog.dlgSize.width * 0.8), (int)((double)TimeInputDialog.dlgSize.height * 0.7));
    private JButton okButton = new JButton("Ok");
    private JButton cancelButton = new JButton("Cancel");
    private CalendarChooser timeChooser;

    public TimeInputDialog(Enum enum_, AstroSoft astroSoft, Date date, final DateListener dateListener) {
        super(astroSoft, enum_.toString(), dlgSize);
        this.initComponents();
        this.timeChooser.setSelectedDate(date);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dateListener.dateChanged(TimeInputDialog.this.timeChooser.getSelectedDate());
                System.out.println("dlg -> " + TimeInputDialog.this.timeChooser.getSelectedDate());
                TimeInputDialog.this.closeDialog();
            }
        });
        this.setVisible(true);
    }

    private void initComponents() {
        this.timeChooser = CalendarChooser.getTimeChooser();
        this.dlgPanel.setLayout(new FlowLayout());
        this.dlgPanel.add(this.createTimeChooser());
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeInputDialog.this.closeDialog();
            }
        });
        this.add(this.dlgPanel);
        this.setBackground(UIConsts.THEME_CLR);
    }

    private JPanel createTimeChooser() {
        JPanel jPanel = new JPanel(new SpringLayout());
        JPanel jPanel2 = this.timeChooser.getChooser(this.getTitle());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        jPanel.add(jPanel3);
        SpringUtilities.makeCompactGrid(jPanel, 2, 1, 5, 5, 10, 10);
        jPanel.setBorder(UIConsts.getTitleBorder(this.getTitle()));
        jPanel.setPreferredSize(panelSize);
        return jPanel;
    }
}

