/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.beans.Degree;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Roman;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Ephemeris;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Cell;
import app.astrosoft.ui.table.ColoredCellRenderer;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DegreeCellRenderer;
import app.astrosoft.ui.table.EphemerisCellRenderer;
import app.astrosoft.ui.table.LocalizedCellRenderer;
import app.astrosoft.ui.table.NumberCellRenderer;
import app.astrosoft.ui.table.NumberFormatRenderer;
import app.astrosoft.ui.table.TableCellPopupListener;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.ui.table.TableRowSelectionListener;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.window.AstrosoftWindow;
import app.astrosoft.ui.window.TablePopupWindowModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AstrosoftTable
extends JTable {
    public static final Color tableBorderClr = Color.GRAY;
    private static final int rowHeight = 22;
    private static final int rowMargin = 2;
    private Font headerFont = UIUtil.getFont(Language.ENGLISH, 1, 12);
    private Font tableFont = new Font("Verdana", 0, 11);
    TableStyle tableStyle;

    public AstrosoftTable(TableModel tableModel, TableStyle tableStyle) {
        super(tableModel);
        this.tableStyle = tableStyle;
        this.setTableProperties();
    }

    private void setTableProperties() {
        this.setHeaderProperties();
        this.setRowHeight(22);
        this.setRowMargin(2);
        this.setRowSelectionAllowed(false);
        this.setShowHorizontalLines(false);
        this.setFont(this.tableFont);
        this.setStyles();
        this.setDefaultRenderer(Number.class, new NumberCellRenderer());
        this.setDefaultRenderer(Roman.class, new NumberCellRenderer());
        this.setDefaultRenderer(Degree.class, new DegreeCellRenderer());
        this.setDefaultRenderer(Ephemeris.EphData.class, new EphemerisCellRenderer());
        this.localizeColumns();
    }

    private void setHeaderProperties() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setFont(this.headerFont);
        jTableHeader.setPreferredSize(new Dimension(this.getPreferredSize().width, 22));
    }

    public void addBorders() {
        this.getTableHeader().setBorder(new LineBorder(tableBorderClr));
        this.setBorder(new LineBorder(tableBorderClr));
    }

    public void addBorder() {
        this.setBorder(new LineBorder(tableBorderClr));
    }

    public void setColumnWidth(int n, AstrosoftTableColumn ... astrosoftTableColumnArray) {
        for (AstrosoftTableColumn astrosoftTableColumn : astrosoftTableColumnArray) {
            int n2 = ((AstrosoftTableModel)this.getModel()).getColumnIndex(astrosoftTableColumn);
            this.getColumnModel().getColumn(n2).setPreferredWidth(n);
        }
        this.setHeaderProperties();
    }

    public void addCellMouseListener(final Cell cell, final TableCellPopupListener tableCellPopupListener) {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            Cell source;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.source = UIUtil.getSourceTableCell(mouseEvent);
                if (!this.source.isAny() && cell.equals(this.source)) {
                    tableCellPopupListener.showPopup(this.source, mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.source = UIUtil.getSourceTableCell(mouseEvent);
                if (!this.source.isAny() && cell.equals(this.source)) {
                    tableCellPopupListener.hidePopup(this.source, mouseEvent.getPoint());
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void addCellPopupWindow(Cell cell, final TablePopupWindowModel tablePopupWindowModel) {
        TableCellPopupListener tableCellPopupListener = new TableCellPopupListener(){
            AstrosoftWindow window;

            @Override
            public void showPopup(Cell cell, Point point) {
                this.window = new AstrosoftWindow();
                Point point2 = AstrosoftTable.this.getLocationOnScreen();
                this.window.setModel(tablePopupWindowModel.getModel(cell));
                point.translate(point2.x + 10, point2.y - 10);
                this.window.show(point);
            }

            @Override
            public void hidePopup(Cell cell, Point point) {
                this.window.dispose();
                AstrosoftTable.this.repaint();
            }
        };
        this.addCellMouseListener(cell, tableCellPopupListener);
    }

    public void addColumnPopupWindow(AstrosoftTableColumn astrosoftTableColumn, TablePopupWindowModel tablePopupWindowModel) {
        this.addCellPopupWindow(new Cell(astrosoftTableColumn), tablePopupWindowModel);
    }

    private void localizeColumns() {
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.getModel();
        ColumnMetaData columnMetaData = astrosoftTableModel.getColumnMetaData();
        for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getLocaleColumns()) {
            TableColumn tableColumn = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(astrosoftTableColumn));
            tableColumn.setCellRenderer(new LocalizedCellRenderer(this.getCellRenderer(astrosoftTableColumn), this.tableFont));
            tableColumn.setHeaderRenderer(new LocalizedCellRenderer(this.getHeaderRenderer(astrosoftTableColumn), this.headerFont));
        }
    }

    public TableCellRenderer getCellRenderer(AstrosoftTableColumn astrosoftTableColumn) {
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.getModel();
        TableCellRenderer tableCellRenderer = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(astrosoftTableColumn)).getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(astrosoftTableModel.getColumnMetaData().getColumnClass(astrosoftTableColumn));
        }
        return tableCellRenderer;
    }

    protected TableCellRenderer getHeaderRenderer(AstrosoftTableColumn astrosoftTableColumn) {
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.getModel();
        TableCellRenderer tableCellRenderer = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(astrosoftTableColumn)).getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    public void setCellColor(Cell cell, Color color, Color color2) {
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.getModel();
        ColumnMetaData columnMetaData = astrosoftTableModel.getColumnMetaData();
        if (cell.isAnyCol()) {
            for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getVisibleColumns()) {
                TableColumn tableColumn = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(astrosoftTableColumn));
                tableColumn.setCellRenderer(new ColoredCellRenderer(this.getCellRenderer(astrosoftTableColumn), cell, columnMetaData.getVisibleColumns(), color, color2));
            }
        } else {
            TableColumn tableColumn = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(cell.col));
            tableColumn.setCellRenderer(new ColoredCellRenderer(this.getCellRenderer(cell.col), cell, columnMetaData.getVisibleColumns(), color, color2));
        }
    }

    public void setRowColor(int n, Color color, Color color2) {
        this.setCellColor(new Cell(n, Cell.ANY_COL), color, color2);
    }

    public void setRowColor(int n, Color color) {
        this.setRowColor(n, color, null);
    }

    public void setColumnColor(AstrosoftTableColumn astrosoftTableColumn, Color color, Color color2) {
        this.setCellColor(new Cell(-1, astrosoftTableColumn), color, color2);
    }

    public void setColumnColor(AstrosoftTableColumn astrosoftTableColumn, Color color) {
        this.setColumnColor(astrosoftTableColumn, color, null);
    }

    public void setColumnNumberFormat(AstrosoftTableColumn astrosoftTableColumn, Format format) {
        TableColumn tableColumn = this.getColumnModel().getColumn(((AstrosoftTableModel)this.getModel()).getColumnIndex(astrosoftTableColumn));
        tableColumn.setCellRenderer(new NumberFormatRenderer(this.getCellRenderer(astrosoftTableColumn), format));
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer, AstrosoftTableColumn astrosoftTableColumn) {
        TableColumn tableColumn = this.getColumnModel().getColumn(((AstrosoftTableModel)this.getModel()).getColumnIndex(astrosoftTableColumn));
        tableColumn.setCellRenderer(tableCellRenderer);
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer, AstrosoftTableColumn astrosoftTableColumn) {
        TableColumn tableColumn = this.getColumnModel().getColumn(((AstrosoftTableModel)this.getModel()).getColumnIndex(astrosoftTableColumn));
        tableColumn.setHeaderRenderer(tableCellRenderer);
    }

    private void setStyles() {
        EnumSet<TableStyle.Style> enumSet = this.tableStyle.styles();
        if (!enumSet.contains((Object)TableStyle.Style.NO_BORDER)) {
            this.addBorders();
        }
        if (enumSet.contains((Object)TableStyle.Style.NO_VER_GRID)) {
            this.setShowVerticalLines(false);
        } else {
            this.setShowVerticalLines(true);
        }
        if (enumSet.contains((Object)TableStyle.Style.NO_SELECTION)) {
            this.setRowSelectionAllowed(false);
        }
        if (enumSet.contains((Object)TableStyle.Style.HOR_LINE)) {
            this.setShowHorizontalLines(true);
        }
        if (enumSet.contains((Object)TableStyle.Style.SINGLE_ROW_SELECTION)) {
            this.setRowSelectionAllowed(true);
            this.setSelectionMode(0);
        }
        if (enumSet.contains((Object)TableStyle.Style.MULTI_ROW_SELECTION)) {
            this.setRowSelectionAllowed(true);
            this.setSelectionMode(2);
        }
        if (enumSet.contains((Object)TableStyle.Style.NO_DRAGING)) {
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        return tableCellRenderer;
    }

    public <E extends TableRowData> void addRowSelectionListener(final TableRowSelectionListener<E> tableRowSelectionListener) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TableData tableData = AstrosoftTable.this.getSelectedData();
                tableRowSelectionListener.selectionChanged(tableData);
            }
        });
        this.setSelectionModel(listSelectionModel);
    }

    public <E extends TableRowData> TableData<E> getSelectedData() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n >= 0) {
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                arrayList.add(i);
            }
        }
        return ((AstrosoftTableModel)this.getModel()).getData(arrayList);
    }
}

