/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AstrosoftTableModel
extends AbstractTableModel {
    protected TableData<? extends TableRowData> rows;
    protected ColumnMetaData columnMetaData;
    private List<AstrosoftTableColumn> columns;

    public AstrosoftTableModel(TableData<? extends TableRowData> tableData, ColumnMetaData columnMetaData) {
        this.rows = tableData;
        this.columnMetaData = columnMetaData;
        this.columns = columnMetaData.getColumns();
    }

    public AstrosoftTableModel(Table table) {
        this(table.getTableData(), table.getColumnMetaData());
    }

    @Override
    public int getRowCount() {
        return this.rows.getRowCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.columns.get(n).toString();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size() - this.columnMetaData.getHiddenColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnMetaData.getColumnClass(this.columns.get(n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TableRowData tableRowData = this.rows.getRow(n);
        Object object = tableRowData.getColumnData(this.columns.get(n2));
        return object;
    }

    public void updateData(TableData<? extends TableRowData> tableData) {
        this.rows = tableData;
        this.fireTableDataChanged();
    }

    public void updateColumns(ColumnMetaData columnMetaData) {
        this.columnMetaData = columnMetaData;
        this.columns = columnMetaData.getColumns();
        this.fireTableStructureChanged();
    }

    public int getColumnIndex(AstrosoftTableColumn astrosoftTableColumn) {
        return this.columns.indexOf((Object)astrosoftTableColumn);
    }

    public AstrosoftTableColumn getColumn(int n) {
        AstrosoftTableColumn astrosoftTableColumn = null;
        try {
            astrosoftTableColumn = this.columns.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return astrosoftTableColumn;
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public <E extends TableRowData> TableData<E> getData(List<Integer> list) {
        ArrayList<TableRowData> arrayList = new ArrayList<TableRowData>();
        for (Integer n : list) {
            arrayList.add(this.rows.getRow(n));
        }
        return TableDataFactory.getTableData(arrayList);
    }
}

