/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;

public class Cell {
    public static final int ANY_ROW = -1;
    public static final AstrosoftTableColumn ANY_COL = null;
    public int row;
    public AstrosoftTableColumn col;

    public Cell(int n, AstrosoftTableColumn astrosoftTableColumn) {
        this.row = n;
        this.col = astrosoftTableColumn;
    }

    public Cell(AstrosoftTableColumn astrosoftTableColumn) {
        this(-1, astrosoftTableColumn);
    }

    public Cell(int n) {
        this(n, ANY_COL);
    }

    public boolean isAny() {
        return this.row == -1 || this.col == ANY_COL;
    }

    public boolean isAnyRow() {
        return this.row == -1;
    }

    public boolean isAnyCol() {
        return this.col == ANY_COL;
    }

    public String toString() {
        return "[ " + this.row + " , " + (Object)((Object)this.col) + " ]";
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Cell cell = (Cell)object;
        if (!this.isAny() && !cell.isAny()) {
            bl = this.row == cell.row && this.col == cell.col;
        } else if (this.isAnyRow() || cell.isAnyRow()) {
            bl = this.col == cell.col;
        } else if (this.isAnyCol() || cell.isAnyCol()) {
            bl = this.row == cell.row;
        }
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n += 31 * this.row;
        return n += 31 * this.col.hashCode();
    }
}

