/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.Cell;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ColoredCellRenderer
implements TableCellRenderer {
    private TableCellRenderer tableCellRenderer;
    private Cell cell;
    private List<AstrosoftTableColumn> cols;
    private Color bgClr;
    private Color fgClr;

    public ColoredCellRenderer(TableCellRenderer tableCellRenderer, Cell cell, List<AstrosoftTableColumn> list, Color color, Color color2) {
        this.tableCellRenderer = tableCellRenderer;
        this.cell = cell;
        this.cols = list;
        this.fgClr = color;
        this.bgClr = color2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.cell.equals(new Cell(n + 1, this.cols.get(n2)))) {
            if (component instanceof JLabel) {
                JLabel jLabel = new JLabel(((JLabel)component).getText());
                if (this.bgClr != null) {
                    jLabel.setBackground(this.bgClr);
                }
                if (this.fgClr != null) {
                    jLabel.setForeground(this.fgClr);
                }
                jLabel.setFont(component.getFont());
                jLabel.setHorizontalAlignment(((JLabel)component).getHorizontalAlignment());
                return jLabel;
            }
        } else {
            component.setForeground(jTable.getForeground());
            component.setBackground(jTable.getBackground());
        }
        return component;
    }
}

