/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.core.Ephemeris;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.util.AstroUtil;
import javax.swing.table.DefaultTableCellRenderer;

public class EphemerisCellRenderer
extends DefaultTableCellRenderer {
    @Override
    protected void setValue(Object object) {
        if (object instanceof Ephemeris.EphData) {
            Ephemeris.EphData ephData = (Ephemeris.EphData)object;
            StringBuilder stringBuilder = new StringBuilder("<html> ");
            String string = UIUtil.getFontTag() + ephData.getHouse().toString(DisplayFormat.SYMBOL) + "</font> ";
            stringBuilder.append(AstroUtil.todegmin(ephData.getPosition(), string));
            if (ephData.isReverse()) {
                stringBuilder.append(UIUtil.getFontTag());
                stringBuilder.append((Object)DisplayStrings.RETRO_SYM);
                stringBuilder.append("</font> ");
            }
            stringBuilder.append("</html> ");
            super.setValue(stringBuilder.toString());
        } else {
            super.setValue(object);
        }
    }
}

