/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListTableData<E extends TableRowData>
implements TableData<E> {
    List<E> rows;

    public ListTableData() {
    }

    public ListTableData(List<E> list) {
        this.rows = list;
    }

    public ListTableData(E[] EArray) {
        this.rows = Arrays.asList(EArray);
    }

    public ListTableData(TableData<E> tableData) {
        this.rows = new ArrayList(tableData.getRowCount());
        for (int i = 0; i < tableData.getRowCount(); ++i) {
            this.rows.add(tableData.getRow(i));
        }
    }

    public ListTableData(TableData<E> tableData, Comparator<TableRowData> comparator) {
        this(tableData);
        Collections.sort(this.rows, comparator);
    }

    @Override
    public E getRow(int n) {
        return (E)((TableRowData)this.rows.get(n));
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public List<E> getAllRows() {
        return this.rows;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getRowCount(); ++i) {
            stringBuilder.append(this.getRow(i).toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

