/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Planet;
import app.astrosoft.ui.util.UIConsts;
import java.awt.Color;
import java.awt.Component;
import java.util.EnumMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PlanetCellRenderer
implements TableCellRenderer {
    private TableCellRenderer tableCellRenderer;
    private boolean highlightRetrogrades;
    private boolean expandRetrogrades;
    private DisplayFormat planetFormat;
    private EnumMap<Planet, Boolean> planetDir;

    public PlanetCellRenderer(TableCellRenderer tableCellRenderer, DisplayFormat displayFormat, boolean bl, boolean bl2, EnumMap<Planet, Boolean> enumMap) {
        this.tableCellRenderer = tableCellRenderer;
        this.highlightRetrogrades = bl;
        this.expandRetrogrades = bl2;
        this.planetFormat = displayFormat;
        this.planetDir = enumMap;
    }

    public PlanetCellRenderer(TableCellRenderer tableCellRenderer) {
        this(tableCellRenderer, DisplayFormat.SYMBOL, false, false, null);
    }

    public PlanetCellRenderer(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2, EnumMap<Planet, Boolean> enumMap) {
        this(tableCellRenderer, DisplayFormat.SYMBOL, bl, bl2, enumMap);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object != null && object instanceof Planet && component instanceof JLabel) {
            JLabel jLabel = new JLabel(((JLabel)component).getText());
            Planet planet = (Planet)((Object)object);
            jLabel.setFont(component.getFont());
            jLabel.setText(planet.toString(this.planetFormat));
            Color color = null;
            if (planet.isAsc()) {
                color = Color.RED;
            }
            if (planet == Planet.Moon) {
                color = Color.MAGENTA;
            }
            if (this.highlightRetrogrades && this.planetDir.containsKey((Object)planet) && this.planetDir.get((Object)planet).booleanValue()) {
                color = UIConsts.GREENISH_BLUE;
                if (this.expandRetrogrades) {
                    jLabel.setText(planet.toString(this.planetFormat) + " (" + (Object)((Object)DisplayStrings.RETRO_SYM) + ")");
                }
            }
            if (color != null) {
                jLabel.setForeground(color);
            } else {
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }
        return component;
    }
}

