/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.SortableHeaderRenderer;
import app.astrosoft.ui.table.SortableTableModel;
import app.astrosoft.ui.util.UIUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableTable
extends AstrosoftTable {
    private static final String IMAGE_ARROW_UP = "arrow_up";
    private static final String IMAGE_ARROW_DOWN = "arrow_down";

    public SortableTable(SortableTableModel sortableTableModel, TableStyle tableStyle) {
        super((TableModel)sortableTableModel, tableStyle);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SortableTable.this.tableHeaderClicked(mouseEvent);
            }
        });
        this.setSortableHeaderRender();
    }

    private void tableHeaderClicked(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.convertColumnIndexToModel(n);
        this.sortData(n2);
    }

    private void sortData(int n) {
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        AstrosoftTableColumn astrosoftTableColumn = sortableTableModel.getColumn(n);
        if (sortableTableModel.getSortableColumns().contains((Object)astrosoftTableColumn)) {
            sortableTableModel.sortData(astrosoftTableColumn);
            this.getTableHeader().repaint();
        }
    }

    public ImageIcon getSortImageIcon() {
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        String string = sortableTableModel.getSortInfo().getSortDir() ? IMAGE_ARROW_DOWN : IMAGE_ARROW_UP;
        return UIUtil.createImageIcon(string);
    }

    private void setSortableHeaderRender() {
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.getModel();
        ColumnMetaData columnMetaData = astrosoftTableModel.getColumnMetaData();
        for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getVisibleColumns()) {
            TableColumn tableColumn = this.getColumnModel().getColumn(astrosoftTableModel.getColumnIndex(astrosoftTableColumn));
            tableColumn.setHeaderRenderer(new SortableHeaderRenderer(this.getHeaderRenderer(astrosoftTableColumn)));
        }
    }
}

