/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.SortInfo;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortableTableModel
extends AstrosoftTableModel {
    private SortInfo sortInfo;
    private List<AstrosoftTableColumn> sortableColumns;

    public SortableTableModel(TableData<? extends TableRowData> tableData, ColumnMetaData columnMetaData) {
        super(tableData, columnMetaData);
    }

    public SortableTableModel(TableData<? extends TableRowData> tableData, ColumnMetaData columnMetaData, AstrosoftTableColumn astrosoftTableColumn) {
        this(tableData, columnMetaData);
        this.sortData(astrosoftTableColumn);
    }

    public void sortData(AstrosoftTableColumn astrosoftTableColumn) {
        if (this.sortInfo != null && this.sortInfo.getSortBy() == astrosoftTableColumn) {
            this.sortInfo.toggleDir();
        } else {
            this.sortInfo = new SortInfo(astrosoftTableColumn);
        }
        this.sortData();
    }

    private void sortData() {
        if (this.sortInfo != null) {
            Comparator<TableRowData> comparator = this.columnMetaData.getColumnComparator(this.sortInfo.getSortBy());
            if (this.sortInfo.getSortDir()) {
                comparator = Collections.reverseOrder(comparator);
            }
            this.rows = TableDataFactory.getSortedTableData(this.rows, comparator);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void updateData(TableData<? extends TableRowData> tableData) {
        this.rows = tableData;
        this.sortData();
    }

    public List<AstrosoftTableColumn> getSortableColumns() {
        return this.columnMetaData.getSortableColumns();
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }
}

