/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.table;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.EnumMapTableData;
import app.astrosoft.ui.table.ExtendedTableData;
import app.astrosoft.ui.table.ListTableData;
import app.astrosoft.ui.table.MapTableRowHelper;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableDataFactory {
    private static final Logger log = Logger.getLogger(TableDataFactory.class.getName());

    public static <E extends TableRowData> TableData<E> getTableData(List<E> list) {
        return new ListTableData<E>(list);
    }

    public static <E extends TableRowData> TableData<E> getTableData(E[] EArray) {
        return new ListTableData(EArray);
    }

    public static <E extends TableRowData> TableData<E> getSortedTableData(TableData<E> tableData, Comparator<TableRowData> comparator) {
        return new ListTableData<E>(tableData, comparator);
    }

    public static <K extends Enum<K>, V extends TableRowData> TableData<V> getTableData(EnumMap<K, V> enumMap, Class<K> clazz) {
        return new EnumMapTableData<K, V>(enumMap, clazz);
    }

    public static <E extends TableRowData> TableData<E> getTableData(TableData<E> tableData, TableData<E> tableData2) {
        return new ExtendedTableData<E>(tableData, tableData2);
    }

    public static <E extends TableRowData> TableData<E> emptyTableData() {
        return new ListTableData(Collections.EMPTY_LIST);
    }

    public static <E extends TableRowData> List<ListTableData<E>> splitTableData(ListTableData<E> listTableData, int n) {
        List<E> list = listTableData.getAllRows();
        ArrayList<ListTableData<ListTableData<E>>> arrayList = new ArrayList<ListTableData<ListTableData<E>>>();
        int n2 = (int)Math.ceil(list.size() / n);
        int n3 = 0;
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            arrayList.add(new ListTableData<E>(list.subList(n3, n3 + n)));
            n3 += n;
        }
        if (n3 < list.size()) {
            arrayList.add(new ListTableData<E>(list.subList(n3, list.size())));
        }
        return arrayList;
    }

    public static <E extends TableRowData> TableData<E> getTableData(Iterable<E> iterable) {
        ArrayList<TableRowData> arrayList = new ArrayList<TableRowData>();
        for (TableRowData tableRowData : iterable) {
            arrayList.add(tableRowData);
        }
        return new ListTableData(arrayList);
    }

    public static <E extends TableRowData> String toCSV(TableData<E> tableData, ColumnMetaData columnMetaData) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < tableData.getRowCount(); ++i) {
            E e = tableData.getRow(i);
            for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getColumns()) {
                stringBuilder.append(e.getColumnData(astrosoftTableColumn));
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static <E extends TableRowData> Table getReversedTable(TableData<E> tableData, ColumnMetaData columnMetaData, AstrosoftTableColumn astrosoftTableColumn, AstrosoftTableColumn astrosoftTableColumn2) {
        Object object;
        Object object2;
        ArrayList<AstrosoftTableColumn> arrayList = new ArrayList<AstrosoftTableColumn>();
        arrayList.add(astrosoftTableColumn2);
        for (int i = 0; i < tableData.getRowCount(); ++i) {
            object2 = tableData.getRow(i);
            object = object2.getColumnData(astrosoftTableColumn);
            try {
                object = object instanceof Enum ? Enum.valueOf(AstrosoftTableColumn.class, ((Enum)object).name()) : Enum.valueOf(AstrosoftTableColumn.class, ((Object)object).toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.SEVERE, "Value of Header column cannot be converted to AstrosoftTableColumn type", illegalArgumentException);
            }
            arrayList.add((AstrosoftTableColumn)((Object)object));
        }
        final DefaultColumnMetaData defaultColumnMetaData = new DefaultColumnMetaData(arrayList);
        object2 = new MapTableRowHelper(defaultColumnMetaData);
        object = new ArrayList();
        ArrayList<AstrosoftTableColumn> arrayList2 = new ArrayList<AstrosoftTableColumn>(columnMetaData.getVisibleColumns());
        arrayList2.remove((Object)astrosoftTableColumn);
        for (AstrosoftTableColumn astrosoftTableColumn3 : arrayList2) {
            Object[] objectArray = new Object[arrayList.size()];
            objectArray[0] = astrosoftTableColumn3;
            for (int i = 0; i < tableData.getRowCount(); ++i) {
                objectArray[i + 1] = tableData.getRow(i).getColumnData(astrosoftTableColumn3);
            }
            object.add(((MapTableRowHelper)object2).createRow(objectArray));
        }
        final TableData tableData2 = TableDataFactory.getTableData(object);
        return new Table(){

            @Override
            public TableData<? extends TableRowData> getTableData() {
                return tableData2;
            }

            @Override
            public ColumnMetaData getColumnMetaData() {
                return defaultColumnMetaData;
            }
        };
    }
}

