/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class UIConsts {
    public static final Color LIGHT_YELLOW = new Color(255, 255, 235);
    public static final Color YELLOWISH_WHITE = new Color(255, 255, 252);
    public static final Color GRAY_WHITE = new Color(238, 238, 238);
    public static final Color LIGHT_BLUE = new Color(0, 0, 204);
    public static final Color DARK_BLUE = new Color(0, 0, 140);
    public static final Color GREENISH_BLUE = new Color(0, 70, 140);
    public static final Color SKY_BLUE = new Color(210, 228, 238);
    public static final Color DARK_GREEN = new Color(0, 90, 0);
    public static final Color LEAF_GREEN = new Color(75, 148, 75);
    public static final Color PEARL_GREEN = new Color(236, 233, 216);
    public static Color DARK_PEARL_GREEN = new Color(218, 216, 200);
    public static final Color DARK_RED = new Color(128, 0, 0);
    public static final Color MEROON_RED = new Color(128, 0, 80);
    public static final Color ROSE = new Color(200, 0, 130);
    public static final Color TABLE_HEADER_BACKGROUND = GRAY_WHITE;
    public static final Color TABLE_HEADER_FOREGROUND = GREENISH_BLUE;
    public static final Color CAL_COMBO_SEL_CLR = Color.RED;
    public static final Color CAL_COMBO_BACKGROUND = LIGHT_YELLOW;
    public static final Color THEME_CLR = PEARL_GREEN;
    public static final Color OPTIONPANE_BACKGROUND = new Color(222, 222, 222);
    public static final Dimension BUTTON_ICON_SIZE = new Dimension(20, 20);

    public static String getLookAndFeel() {
        return "com.digitprop.tonic.TonicLookAndFeel";
    }

    public static Map getUIDefaults() {
        Properties properties = new Properties();
        properties.put("Button.focus", Color.BLACK);
        properties.put("Button.background", THEME_CLR);
        properties.put("Button.rollover", (Object)true);
        properties.put("Panel.background", Color.WHITE);
        properties.put("CheckBox.background", Color.WHITE);
        properties.put("Viewport.background", Color.WHITE);
        properties.put("ComboBox.background", Color.WHITE);
        properties.put("TabbedPane.background", Color.WHITE);
        properties.put("TabbedPane.selected", THEME_CLR);
        properties.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        properties.put("TabbedPane.tabRunOverlay", (Object)5);
        properties.put("MenuBar.background", THEME_CLR);
        properties.put("MenuItem.background", THEME_CLR);
        properties.put("Menu.background", THEME_CLR);
        properties.put("Menu.selectionBackground", LEAF_GREEN);
        properties.put("MenuItem.selectionBackground", LEAF_GREEN);
        properties.put("ToolBar.background", THEME_CLR);
        properties.put("RadioButtonMenuItem.background", THEME_CLR);
        properties.put("RadioButtonMenuItem.selectionBackground", LEAF_GREEN);
        properties.put("PopupMenu.border", new LineBorder(LEAF_GREEN));
        properties.put("Table.foreground", LIGHT_BLUE);
        properties.put("Table.selectionBackground", GRAY_WHITE);
        properties.put("Table.selectionForeground", GREENISH_BLUE);
        properties.put("TableHeader.background", TABLE_HEADER_BACKGROUND);
        properties.put("TableHeader.foreground", TABLE_HEADER_FOREGROUND);
        properties.put("Tree.selectionBackground", LEAF_GREEN);
        properties.put("Tree.selectionBorderColor", LEAF_GREEN);
        properties.put("SplitPane.background", Color.WHITE);
        properties.put("List.selectionBackground", LEAF_GREEN);
        properties.put("List.selectionBorderColor", LEAF_GREEN);
        return properties;
    }

    public static Border getTitleBorder(String string) {
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), string);
        titledBorder.setTitleColor(DARK_GREEN);
        return titledBorder;
    }

    public static Border getTitleBorder(Enum enum_) {
        return UIConsts.getTitleBorder(enum_.toString());
    }

    public static Color getChartBackground() {
        return YELLOWISH_WHITE;
    }

    public static Border getChartBorder() {
        return BorderFactory.createEtchedBorder(0, Color.ORANGE, Color.WHITE);
    }
}

