/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.util;

import app.astrosoft.consts.Language;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Cell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;

public class UIUtil {
    public static final String closeFontTag = "</font> ";
    public static final String htmlTag = "<html> ";
    public static final String closeHtmlTag = "</html> ";
    public static final String brTag = "<br> ";
    public static final ClassLoader classLoader = UIUtil.class.getClassLoader();
    public static final String imagePath = "/resources/images/";

    public static ImageIcon createImageIcon(String string) {
        String string2 = imagePath + string.trim() + ".gif";
        URL uRL = UIUtil.class.getResource(string2);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static Cell getSourceTableCell(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)jTable.getModel();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
        return new Cell(n, astrosoftTableModel.getColumn(n2));
    }

    public static Font getFont(int n, int n2) {
        Language language = AstroSoft.getPreferences().getLanguage();
        Font font = new Font(language.font(), n, n2);
        return font;
    }

    public static Font getFont() {
        return UIUtil.getFont(1, 12);
    }

    public static Font getFont(String string, int n, int n2) {
        Language language = AstroSoft.getPreferences().getLanguage();
        if (language == Language.TAMIL) {
            return new Font(language.font(), n, n2);
        }
        return new Font(string, n, n2);
    }

    public static Font getFont(String string, int n, int n2, int n3) {
        Language language = AstroSoft.getPreferences().getLanguage();
        if (language == Language.TAMIL) {
            return new Font(language.font(), n, n3);
        }
        return new Font(string, n, n2);
    }

    public static Font getFont(int n, int n2, int n3, int n4) {
        Language language = AstroSoft.getPreferences().getLanguage();
        if (language == Language.TAMIL) {
            return new Font(language.font(), n3, n4);
        }
        return new Font(language.font(), n, n2);
    }

    public static Font getFont(Language language, int n, int n2) {
        return new Font(language.font(), n, n2);
    }

    public static void setPanelBackground(JComponent jComponent, Color color) {
        if (jComponent != null) {
            jComponent.setBackground(color);
            for (Component component : jComponent.getComponents()) {
                if (!(component instanceof JPanel)) continue;
                UIUtil.setPanelBackground((JPanel)component, color);
            }
        }
    }

    public static String getFontTag() {
        return " <font face='" + UIUtil.getFont().getFamily() + "' color='#00468C'> ";
    }

    public static void applyOptionPaneBackground(JOptionPane jOptionPane, Color color) {
        jOptionPane.setBackground(color);
        for (Component component : UIUtil.getComponents(jOptionPane)) {
            component.setBackground(color);
        }
    }

    public static final Collection getComponents(Container container) {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            vector.add(componentArray[i]);
            if (!(componentArray[i] instanceof Container)) continue;
            vector.addAll(UIUtil.getComponents((Container)componentArray[i]));
        }
        return vector;
    }

    public static void setWindowLocation(Window window, Component component) {
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x - (dimension2.width - dimension.width) <= 0 && point.y + dimension.height + dimension2.height >= dimension3.height) {
            window.setLocation(0, point.y - dimension2.height);
        } else if (point.x - (dimension2.width - dimension.width) <= 0) {
            window.setLocation(0, point.y + dimension.height);
        } else if (point.y + dimension.height + dimension2.height >= dimension3.height) {
            window.setLocation(point.x - (dimension2.width - dimension.width), point.y - dimension2.height);
        } else {
            window.setLocation(point.x - (dimension2.width - dimension.width), point.y + dimension.height);
        }
    }
}

