/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.AshtaVargaChartData;
import app.astrosoft.consts.AshtavargaName;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Ashtavarga;
import app.astrosoft.ui.comp.AstrosoftTabbedPane;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class AshtavargaView
extends AstrosoftView {
    private static final Dimension tabbedPaneSize = new Dimension(750, 380);
    private static final Dimension viewSize = new Dimension(AshtavargaView.tabbedPaneSize.width, AshtavargaView.tabbedPaneSize.height + 50);
    private static final Dimension chartSize = new Dimension((int)((double)AshtavargaView.viewSize.width * 0.32), (int)((double)AshtavargaView.viewSize.height * 0.55));
    private static final Dimension gunaSize = new Dimension((int)((double)AshtavargaView.viewSize.width * 0.32), (int)((double)AshtavargaView.viewSize.height * 0.2));

    public AshtavargaView(String string, Ashtavarga ashtavarga, Point point) {
        super(string, viewSize, point);
        AstrosoftTabbedPane astrosoftTabbedPane = new AstrosoftTabbedPane(tabbedPaneSize);
        Font font = UIUtil.getFont(1, 12, 1, 10);
        for (AshtavargaName ashtavargaName : AshtavargaName.ashtavargas()) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            Chart chart = new Chart(new AshtaVargaChartData(ashtavargaName, ashtavarga.getAshtavarga(ashtavargaName)), chartSize);
            chart.setTitleFont(font);
            Chart chart2 = new Chart(new AshtaVargaChartData(AshtavargaName.Trikona, ashtavarga.getTrikona(ashtavargaName)), chartSize);
            chart2.setTitleFont(font);
            Chart chart3 = new Chart(new AshtaVargaChartData(AshtavargaName.Ekathipathya, ashtavarga.getEkathipathiya(ashtavargaName)), chartSize);
            chart3.setTitleFont(font);
            jPanel2.add(chart);
            jPanel2.add(chart2);
            jPanel2.add(chart3);
            JPanel jPanel3 = new JPanel();
            if (ashtavargaName != AshtavargaName.SarvaAshtavarga) {
                AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(ashtavarga.getGunaTable(ashtavargaName)), TableStyle.NONE);
                jPanel3.add(astrosoftTable);
                astrosoftTable.setPreferredSize(gunaSize);
            }
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jPanel3, "Last");
            astrosoftTabbedPane.addTab(ashtavargaName.toString(Language.ENGLISH), (Component)jPanel);
        }
        this.add((Component)astrosoftTabbedPane, "Center");
    }
}

