/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Compactibility;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.comp.TitleLabel;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Cell;
import app.astrosoft.ui.table.SortableTable;
import app.astrosoft.ui.table.SortableTableModel;
import app.astrosoft.ui.window.SphutaLabelModel;
import app.astrosoft.ui.window.TablePopupWindowModel;
import app.astrosoft.ui.window.WindowLabelModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class CompPanel
extends JPanel {
    Compactibility c;
    private JLabel ltitle;
    private final int BSTART_X = 20;
    private final int GSTART_X = 410;
    private final int START_Y = 20;
    private final int YINC = 20;
    private final int XINC = 100;
    private int ypos = 20;

    public CompPanel(Compactibility compactibility) {
        this.c = compactibility;
        this.ltitle = new TitleLabel(DisplayStrings.MRAG_COMP_STR);
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.displayInfo();
        this.displayKutas();
        if (compactibility.hasHoroscope()) {
            this.displayDoshas();
            this.displayCharts();
        }
    }

    private void displayInfo() {
        AstrosoftTableModel astrosoftTableModel = new AstrosoftTableModel(this.c.getBoyInfo(), Compactibility.getInfoTableColumnMetaData());
        AstrosoftTableModel astrosoftTableModel2 = new AstrosoftTableModel(this.c.getGirlInfo(), Compactibility.getInfoTableColumnMetaData());
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)astrosoftTableModel, TableStyle.NONE);
        AstrosoftTable astrosoftTable2 = new AstrosoftTable((TableModel)astrosoftTableModel2, TableStyle.NONE);
        astrosoftTable.setColumnWidth(100, AstrosoftTableColumn.Key);
        astrosoftTable2.setColumnWidth(100, AstrosoftTableColumn.Key);
        if (this.c.hasHoroscope()) {
            this.addPopups(astrosoftTable, astrosoftTableModel, astrosoftTable2, astrosoftTableModel2);
        }
        this.add((Component)this.ltitle, new AbsoluteConstraints(230, this.ypos, -1, -1));
        this.ypos += 20;
        this.add((Component)astrosoftTable, new AbsoluteConstraints(20, this.ypos, -1, -1));
        this.add((Component)astrosoftTable2, new AbsoluteConstraints(410, this.ypos, -1, -1));
    }

    private void addPopups(AstrosoftTable astrosoftTable, final AstrosoftTableModel astrosoftTableModel, AstrosoftTable astrosoftTable2, final AstrosoftTableModel astrosoftTableModel2) {
        TablePopupWindowModel tablePopupWindowModel = new TablePopupWindowModel(){
            SphutaLabelModel sphutaModel = new SphutaLabelModel();

            @Override
            public WindowLabelModel getModel(Cell cell) {
                int n = astrosoftTableModel.getColumnIndex(AstrosoftTableColumn.Beeja);
                this.sphutaModel.setSphuta((Double)astrosoftTableModel.getValueAt(cell.row, n));
                return this.sphutaModel;
            }
        };
        astrosoftTable.addCellPopupWindow(new Cell(4), tablePopupWindowModel);
        TablePopupWindowModel tablePopupWindowModel2 = new TablePopupWindowModel(){
            SphutaLabelModel sphutaModel = new SphutaLabelModel();

            @Override
            public WindowLabelModel getModel(Cell cell) {
                int n = astrosoftTableModel2.getColumnIndex(AstrosoftTableColumn.Kshetra);
                this.sphutaModel.setSphuta((Double)astrosoftTableModel2.getValueAt(cell.row, n));
                return this.sphutaModel;
            }
        };
        astrosoftTable2.addCellPopupWindow(new Cell(4), tablePopupWindowModel2);
    }

    private void displayKutas() {
        SortableTableModel sortableTableModel = new SortableTableModel(this.c.getKutaTableData(), Compactibility.getKutaTableColumnMetaData());
        SortableTable sortableTable = new SortableTable(sortableTableModel, TableStyle.STANDARD);
        sortableTable.setColumnWidth(100, AstrosoftTableColumn.Kuta);
        sortableTable.setRowColor(13, Color.RED);
        this.ypos += 120;
        this.add((Component)sortableTable.getTableHeader(), new AbsoluteConstraints(20, this.ypos, -1, -1));
        this.ypos += 23;
        this.add((Component)sortableTable, new AbsoluteConstraints(20, this.ypos, -1, -1));
    }

    public void displayDoshas() {
        this.ypos -= 23;
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(this.c.getDoshaTableData(), Compactibility.getDoshaTableColumnMetaData()), TableStyle.STANDARD);
        astrosoftTable.setRowColor(5, Color.RED);
        astrosoftTable.setColumnNumberFormat(AstrosoftTableColumn.Boy, new DecimalFormat("00.00"));
        astrosoftTable.setColumnNumberFormat(AstrosoftTableColumn.Girl, new DecimalFormat("00.00"));
        this.add((Component)astrosoftTable.getTableHeader(), new AbsoluteConstraints(320, this.ypos, -1, -1));
        this.ypos += 23;
        this.add((Component)astrosoftTable, new AbsoluteConstraints(320, this.ypos, -1, -1));
    }

    private void displayCharts() {
        this.ypos += 320;
        Dimension dimension = new Dimension(360, 320);
        Chart chart = new Chart(new PlanetChartData(Varga.Rasi, this.c.getBoyPlanetaryInfo()), dimension);
        Chart chart2 = new Chart(new PlanetChartData(Varga.Navamsa, this.c.getBoyPlanetaryInfo()), dimension);
        Chart chart3 = new Chart(new PlanetChartData(Varga.Rasi, this.c.getGirlPlanetaryInfo()), dimension);
        Chart chart4 = new Chart(new PlanetChartData(Varga.Navamsa, this.c.getGirlPlanetaryInfo()), dimension);
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.add(chart);
        jPanel.add(chart3);
        jPanel.add(chart2);
        jPanel.add(chart4);
        this.add((Component)jPanel, new AbsoluteConstraints(50, this.ypos, -1, -1));
    }
}

