/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Compactibility;
import app.astrosoft.ui.comp.AstrosoftTabbedPane;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Cell;
import app.astrosoft.ui.table.SortableTable;
import app.astrosoft.ui.table.SortableTableModel;
import app.astrosoft.ui.view.AstrosoftView;
import app.astrosoft.ui.window.SphutaLabelModel;
import app.astrosoft.ui.window.TablePopupWindowModel;
import app.astrosoft.ui.window.WindowLabelModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class CompactibilityView
extends AstrosoftView {
    private static final Dimension tabbedPaneSize = new Dimension(750, 380);
    private static final Dimension viewSize = new Dimension(CompactibilityView.tabbedPaneSize.width, CompactibilityView.tabbedPaneSize.height + 20);
    private static final Dimension kutaTableSize = new Dimension(240, 310);
    private static final Dimension doshaTableSize = new Dimension(250, 134);
    private static final Dimension chartSize = new Dimension(340, 270);
    private Compactibility c;

    public CompactibilityView(String string, Compactibility compactibility, Point point) {
        super(string, viewSize, point);
        this.c = compactibility;
        AstrosoftTabbedPane astrosoftTabbedPane = new AstrosoftTabbedPane(tabbedPaneSize);
        astrosoftTabbedPane.addTab(DisplayStrings.KUTA_STR.toString(Language.ENGLISH), (Component)this.createKutaPanel());
        if (compactibility.hasHoroscope()) {
            astrosoftTabbedPane.addTab(DisplayStrings.DOSHA_STR.toString(Language.ENGLISH), (Component)this.createDoshaPanel());
            astrosoftTabbedPane.addTab(DisplayStrings.BOY_HOR_STR, (Component)this.createBoyChart());
            astrosoftTabbedPane.addTab(DisplayStrings.GIRL_HOR_STR, (Component)this.createGirlChart());
        }
        this.add((Component)astrosoftTabbedPane, "Center");
    }

    private JPanel createKutaPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        SortableTableModel sortableTableModel = new SortableTableModel(this.c.getKutaTableData(), Compactibility.getKutaTableColumnMetaData());
        SortableTable sortableTable = new SortableTable(sortableTableModel, TableStyle.SCROLL);
        sortableTable.setColumnWidth(100, AstrosoftTableColumn.Kuta);
        sortableTable.setRowColor(13, Color.RED);
        AstrosoftTableModel astrosoftTableModel = new AstrosoftTableModel(this.c.getBoyInfo(), Compactibility.getInfoTableColumnMetaData());
        AstrosoftTableModel astrosoftTableModel2 = new AstrosoftTableModel(this.c.getGirlInfo(), Compactibility.getInfoTableColumnMetaData());
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)astrosoftTableModel, TableStyle.NONE);
        AstrosoftTable astrosoftTable2 = new AstrosoftTable((TableModel)astrosoftTableModel2, TableStyle.NONE);
        astrosoftTable.setColumnWidth(100, AstrosoftTableColumn.Key);
        astrosoftTable2.setColumnWidth(100, AstrosoftTableColumn.Key);
        if (this.c.hasHoroscope()) {
            this.addPopups(astrosoftTable, astrosoftTableModel, astrosoftTable2, astrosoftTableModel2);
        }
        TitledTable titledTable = new TitledTable(sortableTable, kutaTableSize);
        jPanel.add(astrosoftTable);
        jPanel.add(titledTable);
        jPanel.add(astrosoftTable2);
        sortableTable.setPreferredScrollableViewportSize(kutaTableSize);
        return jPanel;
    }

    private void addPopups(AstrosoftTable astrosoftTable, final AstrosoftTableModel astrosoftTableModel, AstrosoftTable astrosoftTable2, final AstrosoftTableModel astrosoftTableModel2) {
        TablePopupWindowModel tablePopupWindowModel = new TablePopupWindowModel(){
            SphutaLabelModel sphutaModel = new SphutaLabelModel();

            @Override
            public WindowLabelModel getModel(Cell cell) {
                int n = astrosoftTableModel.getColumnIndex(AstrosoftTableColumn.Beeja);
                this.sphutaModel.setSphuta((Double)astrosoftTableModel.getValueAt(cell.row, n));
                return this.sphutaModel;
            }
        };
        astrosoftTable.addCellPopupWindow(new Cell(4), tablePopupWindowModel);
        TablePopupWindowModel tablePopupWindowModel2 = new TablePopupWindowModel(){
            SphutaLabelModel sphutaModel = new SphutaLabelModel();

            @Override
            public WindowLabelModel getModel(Cell cell) {
                int n = astrosoftTableModel2.getColumnIndex(AstrosoftTableColumn.Kshetra);
                this.sphutaModel.setSphuta((Double)astrosoftTableModel2.getValueAt(cell.row, n));
                return this.sphutaModel;
            }
        };
        astrosoftTable2.addCellPopupWindow(new Cell(4), tablePopupWindowModel2);
    }

    private JPanel createDoshaPanel() {
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(this.c.getDoshaTableData(), Compactibility.getDoshaTableColumnMetaData()), TableStyle.STANDARD);
        astrosoftTable.setRowColor(5, Color.RED);
        astrosoftTable.setColumnNumberFormat(AstrosoftTableColumn.Boy, new DecimalFormat("00.00"));
        astrosoftTable.setColumnNumberFormat(AstrosoftTableColumn.Girl, new DecimalFormat("00.00"));
        return new TitledTable(astrosoftTable, doshaTableSize);
    }

    private JPanel createBoyChart() {
        Chart chart = new Chart(new PlanetChartData(Varga.Rasi, this.c.getBoyPlanetaryInfo()), chartSize);
        Chart chart2 = new Chart(new PlanetChartData(Varga.Navamsa, this.c.getBoyPlanetaryInfo()), chartSize);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(chart);
        jPanel.add(chart2);
        jPanel.setPreferredSize(new Dimension(CompactibilityView.chartSize.width * 2, CompactibilityView.chartSize.height + 70));
        return jPanel;
    }

    private JPanel createGirlChart() {
        Chart chart = new Chart(new PlanetChartData(Varga.Rasi, this.c.getGirlPlanetaryInfo()), chartSize);
        Chart chart2 = new Chart(new PlanetChartData(Varga.Navamsa, this.c.getGirlPlanetaryInfo()), chartSize);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(chart);
        jPanel.add(chart2);
        jPanel.setPreferredSize(new Dimension(CompactibilityView.chartSize.width * 2, CompactibilityView.chartSize.height + 70));
        return jPanel;
    }
}

