/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Ephemeris;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.comp.CalendarChooser;
import app.astrosoft.ui.comp.CalendarSpinner;
import app.astrosoft.ui.comp.DateListener;
import app.astrosoft.ui.comp.TitleLabel;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import app.astrosoft.util.AstroUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class EphemerisView
extends AstrosoftView {
    private static final Dimension viewSize = new Dimension(750, 450);
    private static final Dimension dailyTableSize = new Dimension(EphemerisView.viewSize.width, EphemerisView.viewSize.height);
    private static final Dimension monthyTableSize = new Dimension(EphemerisView.viewSize.width, 288);
    private AstrosoftTable ephTable;
    private AstrosoftTableModel tableModel;
    private TitledTable tablePanel;
    private CalendarChooser monthChooser;
    private Calendar ephDate;
    private Ephemeris.Mode ephMode;

    public EphemerisView(Ephemeris ephemeris, Point point) {
        super(viewSize, point);
        this.ephMode = ephemeris.getMode();
        this.ephDate = ephemeris.getDate();
        this.tableModel = new AstrosoftTableModel(ephemeris.getEphemerisTable());
        this.ephTable = new AstrosoftTable((TableModel)this.tableModel, TableStyle.SCROLL_SINGLE_ROW_SELECT);
        this.ephTable.setColumnWidth(60, AstrosoftTableColumn.Sun, AstrosoftTableColumn.Moon, AstrosoftTableColumn.Rahu, AstrosoftTableColumn.Ketu);
        this.monthChooser = CalendarChooser.getMonthChooser();
        this.tablePanel = new TitledTable(this.ephTable, dailyTableSize);
        JTableHeader jTableHeader = this.ephTable.getTableHeader();
        this.tablePanel.add((Component)this.createEphSelector(jTableHeader.getBackground(), jTableHeader.getForeground()), "First");
        this.add((Component)this.tablePanel, "First");
        this.monthChooser.addDateListener(new DateListener(){

            @Override
            public void dateChanged(Date date) {
                EphemerisView.this.ephDate = AstroUtil.getCalendar(date);
                EphemerisView.this.updateEphTable();
            }
        });
    }

    private void updateEphTable() {
        Table table = new Ephemeris(this.ephDate, this.ephMode).getEphemerisTable();
        this.tableModel.updateColumns(table.getColumnMetaData());
        this.tableModel.updateData(table.getTableData());
    }

    private JPanel createEphModeSelector(Color color, Color color2) {
        JPanel jPanel = new JPanel();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EphemerisView.this.ephMode = Ephemeris.Mode.valueOf(actionEvent.getActionCommand());
                if (EphemerisView.this.ephMode.isMonthly()) {
                    EphemerisView.this.tablePanel.setScrollPaneSize(monthyTableSize);
                    ((CalendarSpinner)EphemerisView.this.monthChooser).setDateFormat("yyyy");
                } else {
                    EphemerisView.this.tablePanel.setScrollPaneSize(dailyTableSize);
                    int n = EphemerisView.this.ephTable.getSelectedRow();
                    if (n != -1) {
                        EphemerisView.this.ephDate.set(2, n);
                    }
                    EphemerisView.this.monthChooser.setSelectedDate(EphemerisView.this.ephDate.getTime());
                    ((CalendarSpinner)EphemerisView.this.monthChooser).setDateFormat("MMM yyyy");
                }
                EphemerisView.this.updateEphTable();
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Ephemeris.Mode mode : Ephemeris.Mode.values()) {
            JRadioButton jRadioButton = new JRadioButton(mode.toString());
            buttonGroup.add(jRadioButton);
            jRadioButton.setActionCommand(mode.name());
            jRadioButton.addActionListener(actionListener);
            jPanel.add(jRadioButton);
            jRadioButton.setBackground(color);
            jRadioButton.setForeground(color2);
            if (mode != this.ephMode) continue;
            jRadioButton.setSelected(true);
        }
        jPanel.setBackground(color);
        return jPanel;
    }

    private JPanel createEphTitle(Color color, Color color2) {
        JPanel jPanel = new JPanel();
        AstrosoftPref astrosoftPref = AstroSoft.getPreferences();
        StringBuilder stringBuilder = new StringBuilder(DisplayStrings.EPHEMERIS_STR.toString());
        stringBuilder.append(" For ");
        stringBuilder.append(astrosoftPref.getPlace().city());
        stringBuilder.append(" at ");
        stringBuilder.append(AstroUtil.timeFormat(astrosoftPref.getEphCalcTime()));
        TitleLabel titleLabel = new TitleLabel(stringBuilder.toString());
        jPanel.add(titleLabel);
        titleLabel.setFont(UIUtil.getFont(Language.ENGLISH, 1, 12));
        titleLabel.setForeground(color2);
        jPanel.setBackground(color);
        return jPanel;
    }

    private JPanel createEphSelector(Color color, Color color2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.monthChooser.getChooser();
        this.monthChooser.setBackground(color);
        this.monthChooser.setForeground(color2);
        jPanel.setBackground(color);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.createEphTitle(color, color2), "Center");
        jPanel.add((Component)this.createEphModeSelector(color, color2), "East");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }
}

