/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.persistence.NumerologicalName;
import app.astrosoft.service.NumeroNameService;
import app.astrosoft.ui.comp.EmptyPagination;
import app.astrosoft.ui.comp.NameAddPanel;
import app.astrosoft.ui.comp.NameSearchPanel;
import app.astrosoft.ui.comp.NumeroNamePagination;
import app.astrosoft.ui.comp.PagingPanel;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.ui.table.TableRowSelectionListener;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.table.TableModel;

public class FindNameView
extends AstrosoftView {
    private static final Logger log = Logger.getLogger(FindNameView.class.getName());
    private static final Dimension size;
    private static final Dimension tableSize;
    private static final Point loc;
    private NameSearchPanel searchPanel;
    private NameAddPanel addPanel;
    private AstrosoftTable nameTable;
    private JButton deleteButton;
    private JPanel tablePanel;
    private PagingPanel<NumerologicalName> pagingPanel;
    private int pageLength = 15;
    private TableData<? extends TableRowData> data = TableDataFactory.emptyTableData();
    AstrosoftTableModel nameModel;

    public FindNameView() {
        super(DisplayStrings.FIND_NAME_STR.toString(), size, loc);
        this.searchPanel = new NameSearchPanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindNameView.this.searchButtonClicked();
            }
        });
        this.addPanel = new NameAddPanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindNameView.this.addButtonClicked();
            }
        });
        this.constructTabbedPane();
        this.constructNameTable();
    }

    private void constructTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(DisplayStrings.SEARCH_STR.toString(), this.searchPanel);
        jTabbedPane.addTab(DisplayStrings.ADD_STR.toString(), this.addPanel);
        this.add((Component)jTabbedPane, "First");
    }

    private void constructNameTable() {
        this.nameModel = new AstrosoftTableModel(this.data, NumerologicalName.getColumnMetaData());
        this.nameTable = new AstrosoftTable((TableModel)this.nameModel, TableStyle.MULTI_ROW_GRID);
        this.tablePanel = new TitledTable(null, this.nameTable, tableSize, this.createFooter());
        this.add((Component)this.tablePanel, "Center");
        this.nameTable.addRowSelectionListener(new TableRowSelectionListener<NumerologicalName>(){

            @Override
            public void selectionChanged(TableData<NumerologicalName> tableData) {
                if (tableData.getRowCount() > 0) {
                    NumerologicalName numerologicalName = tableData.getRow(0);
                    FindNameView.this.addPanel.setValues(numerologicalName.getName(), numerologicalName.getNumeroVal(), numerologicalName.getNumeroNum());
                }
            }
        });
        this.tablePanel.setVisible(false);
    }

    private JPanel createFooter() {
        this.deleteButton = new JButton(DisplayStrings.DELETE_STR.toString());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(UIConsts.THEME_CLR);
        jPanel2.add(this.deleteButton);
        jPanel.add((Component)jPanel2, "Center");
        this.createPagingPanel(jPanel);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                log.fine("Delete Button Clicked");
                TableData tableData = FindNameView.this.nameTable.getSelectedData();
                ArrayList<NumerologicalName> arrayList = new ArrayList<NumerologicalName>();
                for (int i = 0; i < tableData.getRowCount(); ++i) {
                    arrayList.add((NumerologicalName)tableData.getRow(i));
                }
                NumeroNameService.deleteNames(arrayList);
                FindNameView.this.searchButtonClicked();
            }
        });
        return jPanel;
    }

    private void createPagingPanel(JPanel jPanel) {
        EmptyPagination emptyPagination = EmptyPagination.getInstance(this.pageLength);
        this.pagingPanel = new PagingPanel(this.nameModel, emptyPagination);
        jPanel.add(this.pagingPanel, "East");
    }

    private void searchButtonClicked() {
        log.fine("Name Search Button Clicked");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.tablePanel.setVisible(true);
        this.pagingPanel.setPagination(new NumeroNamePagination(this.searchPanel.getName(), this.searchPanel.getNumeroValue(), this.searchPanel.getNumeroNumber(), this.searchPanel.getOperator1(), this.searchPanel.getOperator2(), this.pageLength));
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void addButtonClicked() {
        log.fine("Name Add Button Clicked");
        NumeroNameService.addName(this.addPanel.getName());
        this.addPanel.resetValues();
        this.searchButtonClicked();
    }

    static {
        tableSize = size = new Dimension(700, 436);
        loc = new Point(50, 10);
    }
}

