/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.Interval;
import app.astrosoft.beans.MuhurthaBean;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Muhurtha;
import app.astrosoft.ui.AstrosoftActionHandler;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.Cell;
import app.astrosoft.ui.table.SortableTable;
import app.astrosoft.ui.table.SortableTableModel;
import app.astrosoft.ui.window.DefaultWindowLabelModel;
import app.astrosoft.ui.window.TablePopupWindowModel;
import app.astrosoft.ui.window.WindowLabelModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;

public class MuhurthaPanel
extends JPanel {
    private static final int VISIBLE_TABLE_ROWS = 15;
    private Muhurtha muhurtha;
    private Point loc = new Point(20, 30);
    private Dimension tableSize = new Dimension(700, 350);
    private AstrosoftActionHandler handler;
    SortableTableModel model;
    SortableTable mTable;
    JButton okButton;
    JButton panButton;

    public MuhurthaPanel(Muhurtha muhurtha, AstrosoftActionHandler astrosoftActionHandler) {
        this.muhurtha = muhurtha;
        this.handler = astrosoftActionHandler;
        muhurtha.calcMuhurtha();
        this.model = new SortableTableModel(muhurtha.getNextTransitPeriods(), MuhurthaBean.getColumnMetaData(), AstrosoftTableColumn.Period);
        this.mTable = new SortableTable(this.model, TableStyle.SCROLL_SINGLE_ROW_SELECT);
        this.okButton = new JButton("More");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuhurthaPanel.this.moreClicked();
            }
        });
        this.panButton = new JButton("Panchang");
        this.panButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuhurthaPanel.this.panchangClicked();
            }
        });
        TablePopupWindowModel tablePopupWindowModel = new TablePopupWindowModel(){
            DefaultWindowLabelModel windowModel = new DefaultWindowLabelModel();

            @Override
            public WindowLabelModel getModel(Cell cell) {
                int n;
                switch (cell.col) {
                    case Nakshathra: {
                        n = MuhurthaPanel.this.model.getColumnIndex(AstrosoftTableColumn.Longitude);
                        break;
                    }
                    case Period: {
                        n = MuhurthaPanel.this.model.getColumnIndex(AstrosoftTableColumn.PeriodPopup);
                        break;
                    }
                    default: {
                        n = MuhurthaPanel.this.model.getColumnIndex(cell.col);
                    }
                }
                this.windowModel.setText(MuhurthaPanel.this.model.getValueAt(cell.row, n).toString());
                return this.windowModel;
            }
        };
        this.mTable.addColumnPopupWindow(AstrosoftTableColumn.Period, tablePopupWindowModel);
        this.mTable.addColumnPopupWindow(AstrosoftTableColumn.Nakshathra, tablePopupWindowModel);
        this.setLayout(new BorderLayout());
        this.showPanel();
    }

    public void setLoc(Point point) {
        this.loc = point;
    }

    public void setTableSize(Dimension dimension) {
        this.tableSize = dimension;
    }

    public void showPanel() {
        this.setBounds(this.loc.x, this.loc.y, this.tableSize.width + this.loc.x + 50, this.tableSize.height + this.loc.y + 40);
        this.showTable();
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.panButton);
        this.add((Component)jPanel, "Last");
    }

    private void showTable() {
        this.mTable.setPreferredScrollableViewportSize(this.tableSize);
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        JPanel jPanel = new JPanel();
        jPanel.add(this.mTable.getTableHeader());
        jPanel.add(jScrollPane);
        this.add((Component)jPanel, "Center");
        if (this.mTable.getModel().getRowCount() <= 15) {
            this.mTable.setBorder(new LineBorder(AstrosoftTable.tableBorderClr));
            jScrollPane.setBorder(new LineBorder(this.getBackground()));
            this.mTable.getTableHeader().setBorder(new LineBorder(AstrosoftTable.tableBorderClr));
        }
    }

    private void moreClicked() {
        this.model.updateData(this.muhurtha.getNextTransitPeriods());
    }

    private void panchangClicked() {
        int n = this.mTable.getSelectedRow();
        if (n != -1) {
            AstrosoftTableModel astrosoftTableModel = (AstrosoftTableModel)this.mTable.getModel();
            Calendar calendar = new GregorianCalendar();
            try {
                calendar = Interval.parseDate((String)astrosoftTableModel.getValueAt(n, astrosoftTableModel.getColumnIndex(AstrosoftTableColumn.Period)), DisplayFormat.DATE);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            this.handler.showPanchang(calendar);
        }
    }
}

