/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Panchang;
import app.astrosoft.ui.comp.CalendarChooser;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.comp.DateListener;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.MultiLineCellRenderer;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;

public class PanchangView
extends AstrosoftView {
    private static final Dimension viewSize = new Dimension(750, 450);
    private static final Dimension chartSize = new Dimension(350, 300);
    private static final int KeyColWidth = 130;
    private static final int ValueColWidth = 250;
    private static final int RowHeight = 30;
    private static final int AusRowHeight = 100;
    private static final Dimension headerSize = new Dimension(380, 30);
    private CalendarChooser dateChooser;
    private Panchang pan;
    private AstrosoftTableModel panTableModel;
    private AstrosoftTable panTable;

    public PanchangView(Panchang panchang, Point point) {
        super(viewSize, point);
        this.pan = panchang;
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createPanTable(), "West");
        final JPanel jPanel2 = this.createChartPanel();
        jPanel.add((Component)jPanel2, "East");
        this.dateChooser.addDateListener(new DateListener(){

            @Override
            public void dateChanged(Date date) {
                Panchang panchang = new Panchang(date);
                PanchangView.this.panTableModel.updateData(panchang.getPanchangTableData());
                PanchangView.this.panTable.setRowHeight(9, 100);
                jPanel.remove(jPanel2);
                jPanel2.removeAll();
                jPanel2.add(new Chart(panchang.getPlanetChartData(), chartSize));
                jPanel.add((Component)jPanel2, "East");
            }
        });
        this.add(jPanel);
    }

    private JPanel createChartPanel() {
        Chart chart = new Chart(this.pan.getPlanetChartData(), chartSize);
        JPanel jPanel = new JPanel();
        jPanel.add(chart);
        return jPanel;
    }

    private JPanel createPanTable() {
        this.panTableModel = new AstrosoftTableModel(this.pan.getPanchangTable());
        this.panTable = new AstrosoftTable(this.panTableModel, TableStyle.GRID){
            TableCellRenderer multiLineRenderer;
            {
                this.multiLineRenderer = new MultiLineCellRenderer(",");
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n == 9 && n2 == 1) {
                    return this.multiLineRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.panTable.setColumnWidth(250, AstrosoftTableColumn.Value);
        this.panTable.setColumnWidth(130, AstrosoftTableColumn.Key);
        this.panTable.setRowHeight(30);
        this.panTable.setRowHeight(9, 100);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.panTable);
        jPanel.add((Component)this.createPanTableHeader(), "First");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createPanTableHeader() {
        this.dateChooser = CalendarChooser.getDateChooser();
        JPanel jPanel = this.dateChooser.getChooser();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(DisplayStrings.DATE_STR.toString());
        jLabel.setFont(UIUtil.getFont());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel, "East");
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setPreferredSize(new Dimension(130, 30));
        jPanel.setPreferredSize(new Dimension(250, 30));
        jPanel2.setPreferredSize(headerSize);
        jPanel2.setBackground(UIConsts.TABLE_HEADER_BACKGROUND);
        jLabel.setForeground(UIConsts.TABLE_HEADER_FOREGROUND);
        this.dateChooser.setBackground(UIConsts.TABLE_HEADER_BACKGROUND);
        this.dateChooser.setForeground(UIConsts.TABLE_HEADER_FOREGROUND);
        this.dateChooser.setSelectedDate(this.pan.getDate().getTime());
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        return jPanel3;
    }
}

