/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.ui.comp.TitleLabel;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.PlanetCellRenderer;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.TableModel;

public class PlanetView
extends AstrosoftView {
    PlanetaryInfo planetaryInfo;

    public PlanetView(String string, PlanetaryInfo planetaryInfo) {
        super(string, new Dimension(600, 295));
        this.planetaryInfo = planetaryInfo;
        DefaultColumnMetaData defaultColumnMetaData = planetaryInfo.getPlanateryInfoColumnMetaData();
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(planetaryInfo.getPlanateryInfoTableData(), defaultColumnMetaData), TableStyle.STANDARD);
        astrosoftTable.setCellRenderer(new PlanetCellRenderer(astrosoftTable.getCellRenderer(AstrosoftTableColumn.Planet), DisplayFormat.FULL_NAME, true, true, planetaryInfo.getPlanetDirection()), AstrosoftTableColumn.Planet);
        TitleLabel titleLabel = new TitleLabel(DisplayStrings.PLANET_POS_STR);
        TitledTable titledTable = new TitledTable(titleLabel, astrosoftTable, this.viewSize);
        this.add((Component)titledTable, "Center");
        this.setVisible(true);
    }
}

