/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.ShadBala;
import app.astrosoft.ui.comp.AstrosoftTabbedPane;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.SortableTable;
import app.astrosoft.ui.table.SortableTableModel;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class ShadBalaView
extends AstrosoftView {
    ShadBala shadBala;
    private static final Dimension planetBalaTableSize = new Dimension(710, 222);
    private static final Dimension bhavaBalaTableSize = new Dimension(630, 288);
    private static final Dimension tabbedPaneSize = new Dimension(750, 380);
    private static final Dimension panelSize = new Dimension(ShadBalaView.tabbedPaneSize.width, ShadBalaView.tabbedPaneSize.height + 20);

    public ShadBalaView(String string, ShadBala shadBala, Point point) {
        super(string, panelSize, point);
        this.shadBala = shadBala;
        JLabel jLabel = new JLabel();
        TitledTable titledTable = new TitledTable(jLabel, this.makePlanetBalaTable(), planetBalaTableSize);
        TitledTable titledTable2 = new TitledTable(jLabel, this.makeBhavaBalaTable(), bhavaBalaTableSize);
        TitledTable titledTable3 = new TitledTable(jLabel, this.makeSthanaBalaTable(), planetBalaTableSize);
        TitledTable titledTable4 = new TitledTable(jLabel, this.makeKalaBalaTable(), planetBalaTableSize);
        AstrosoftTabbedPane astrosoftTabbedPane = new AstrosoftTabbedPane(tabbedPaneSize);
        astrosoftTabbedPane.addTab(AstrosoftTableColumn.ShadBala.toString(Language.ENGLISH), (Component)titledTable);
        astrosoftTabbedPane.addTab(AstrosoftTableColumn.SthanaBala.toString(Language.ENGLISH), (Component)titledTable3);
        astrosoftTabbedPane.addTab(AstrosoftTableColumn.KalaBala.toString(Language.ENGLISH), (Component)titledTable4);
        astrosoftTabbedPane.addTab(AstrosoftTableColumn.BhavaBala.toString(Language.ENGLISH), (Component)titledTable2);
        this.add((Component)astrosoftTabbedPane, "Center");
        this.setVisible(true);
    }

    private AstrosoftTable makeKalaBalaTable() {
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(this.shadBala.getPlanetBalaTableData(), this.shadBala.getKalaBalaColumnMetaData()), TableStyle.STANDARD);
        astrosoftTable.setColumnWidth(100, AstrosoftTableColumn.NatonnataBala);
        astrosoftTable.setColumnColor(AstrosoftTableColumn.KalaBala, Color.RED);
        return astrosoftTable;
    }

    private AstrosoftTable makeSthanaBalaTable() {
        AstrosoftTable astrosoftTable = new AstrosoftTable((TableModel)new AstrosoftTableModel(this.shadBala.getPlanetBalaTableData(), this.shadBala.getSthanaBalaColumnMetaData()), TableStyle.STANDARD);
        astrosoftTable.setColumnWidth(120, AstrosoftTableColumn.OjaYugmarasyamsaBala);
        astrosoftTable.setColumnWidth(100, AstrosoftTableColumn.SaptavargajaBala);
        astrosoftTable.setColumnColor(AstrosoftTableColumn.SthanaBala, Color.RED);
        return astrosoftTable;
    }

    private AstrosoftTable makeBhavaBalaTable() {
        SortableTable sortableTable = new SortableTable(new SortableTableModel(this.shadBala.getBhavaBalaTableData(), this.shadBala.getBhavaBalaColumnMetaData()), TableStyle.STANDARD);
        sortableTable.setColumnWidth(100, AstrosoftTableColumn.BhavaAdhipathiBala);
        sortableTable.setColumnColor(AstrosoftTableColumn.Rank, UIConsts.DARK_RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.BhavaBala, Color.RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.Rupa, Color.RED);
        sortableTable.setColumnNumberFormat(AstrosoftTableColumn.Rupa, new DecimalFormat("0.0"));
        return sortableTable;
    }

    private AstrosoftTable makePlanetBalaTable() {
        SortableTable sortableTable = new SortableTable(new SortableTableModel(this.shadBala.getPlanetBalaTableData(), this.shadBala.getPlanetBalaColumnMetaData()), TableStyle.STANDARD);
        sortableTable.setColumnColor(AstrosoftTableColumn.Rank, UIConsts.DARK_RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.ShadBala, Color.RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.BalaPercentage, Color.RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.Rupa, Color.RED);
        sortableTable.setColumnColor(AstrosoftTableColumn.KashtaBala, Color.BLACK);
        sortableTable.setColumnColor(AstrosoftTableColumn.IshtaBala, UIConsts.DARK_GREEN);
        sortableTable.setColumnNumberFormat(AstrosoftTableColumn.Rupa, new DecimalFormat("0.0"));
        sortableTable.setColumnNumberFormat(AstrosoftTableColumn.ResidentialStrength, new DecimalFormat("00.0"));
        return sortableTable;
    }
}

