/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.Varga;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VargaChartView
extends AstrosoftView {
    private static final Dimension viewSize = new Dimension(650, 400);
    private static final Dimension vargaSize = new Dimension((int)((double)VargaChartView.viewSize.width * 0.2), VargaChartView.viewSize.height);
    private static final Dimension chartSize = new Dimension((int)((double)VargaChartView.viewSize.width * 0.7), (int)((double)VargaChartView.viewSize.height * 0.65));
    private JPanel chartPanel;
    private PlanetaryInfo planetaryInfo;

    public VargaChartView(String string, PlanetaryInfo planetaryInfo) {
        super(string, viewSize);
        this.planetaryInfo = planetaryInfo;
        JPanel jPanel = new JPanel();
        final JList<Varga> jList = new JList<Varga>(Varga.values());
        jList.setFont(UIUtil.getFont("Tahoma", 0, 11));
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        jPanel.add(jList);
        jPanel.setPreferredSize(vargaSize);
        this.chartPanel = new JPanel(new BorderLayout());
        this.chartPanel.add((Component)new Chart(new PlanetChartData(Varga.Bhava, planetaryInfo), chartSize), "Center");
        final JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.chartPanel);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jSplitPane.setBorder(BorderFactory.createEtchedBorder());
        this.chartPanel.setBorder(BorderFactory.createEmptyBorder());
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jSplitPane.remove(VargaChartView.this.chartPanel);
                VargaChartView.this.vargaChanged((Varga)((Object)jList.getSelectedValue()));
                jSplitPane.add(VargaChartView.this.chartPanel);
            }
        });
        this.add((Component)jSplitPane, "Center");
    }

    private void vargaChanged(Varga varga) {
        this.chartPanel.removeAll();
        this.chartPanel.add((Component)new Chart(new PlanetChartData(varga, this.planetaryInfo), chartSize), "Center");
    }
}

