/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.Command;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.ui.view.ViewContainer;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;

public class ViewManager {
    private ViewContainer container;

    public ViewManager(ViewContainer viewContainer) {
        this.container = viewContainer;
    }

    public void showView(View view) {
        JPanel jPanel = this.container.createView(view);
        this.container.addView(jPanel);
    }

    public static enum View {
        CHART_VIEW("Chart"),
        DASAS_VIEW(DisplayStrings.DASA_STR.toString(Language.ENGLISH)),
        PLANET_POS_VIEW(DisplayStrings.PLANET_POS_STR.toString(Language.ENGLISH)),
        BHAVA_POS_VIEW(DisplayStrings.BHAVA_POS_STR.toString(Language.ENGLISH)),
        DIV_CHART_VIEW(DisplayStrings.DIV_CHARTS_STR.toString(Language.ENGLISH)),
        ASHTAVARGA_VIEW(DisplayStrings.ASHTAVARGA_STR.toString(Language.ENGLISH)),
        SHADBALA_VIEW(DisplayStrings.SHADBALA_STR.toString(Language.ENGLISH)),
        PANCHANG_VIEW("Panchang"),
        EPHEMERIS_VIEW("Ephemeris"),
        COMPACTIBILITY_VIEW("Marriage Compactibility"),
        MUHURTHA_VIEW("Muhurtha"),
        FIND_NAME_VIEW(DisplayStrings.FIND_NAME_STR.toString(Language.ENGLISH)),
        YOGA_COMBINATIONS_VIEW(DisplayStrings.YOGA_COMBINATIONS_STR.toString(Language.ENGLISH));

        private String displayVal;

        private View(String string2) {
            this.displayVal = string2;
        }

        public String displayVal() {
            return this.displayVal;
        }

        public String toString() {
            return this.displayVal;
        }

        public static Set<Command> commands() {
            HashSet<Command> hashSet = new HashSet<Command>();
            for (View view : View.values()) {
                hashSet.add(Command.valueOf(view.name()));
            }
            return hashSet;
        }
    }
}

