/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.TableStyle;
import app.astrosoft.core.Dasa;
import app.astrosoft.core.Vimshottari;
import app.astrosoft.ui.comp.TitleLabel;
import app.astrosoft.ui.comp.TitledTable;
import app.astrosoft.ui.table.AstrosoftTable;
import app.astrosoft.ui.table.AstrosoftTableModel;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.tree.DasaTreeCellRenderer;
import app.astrosoft.ui.tree.DasaTreeListener;
import app.astrosoft.ui.tree.DasaTreeSelectionHandler;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VimDasaView
extends AstrosoftView
implements DasaTreeSelectionHandler {
    private Vimshottari v;
    private AstrosoftTableModel dasaTableModel;
    private AstrosoftTable dasaTable;
    private TitleLabel dasaTitle;
    private static final Dimension viewSize = new Dimension(580, 400);
    private static final Dimension treeSize = new Dimension((int)((double)VimDasaView.viewSize.width * 0.3), VimDasaView.viewSize.height);
    private static final Dimension tableSize = new Dimension((int)((double)VimDasaView.viewSize.width * 0.6), (int)((double)VimDasaView.viewSize.height * 0.56));

    public VimDasaView(String string, Vimshottari vimshottari) {
        super(string, viewSize);
        this.v = vimshottari;
        Font font = UIUtil.getFont("Tahoma", 0, 11);
        Font font2 = UIUtil.getFont(1, 12);
        JTree jTree = new JTree(vimshottari.getDasaTreeModel());
        jTree.setFont(font);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(new DasaTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(jTree);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(treeSize);
        this.dasaTableModel = new AstrosoftTableModel(vimshottari.getVimDasaTableData(), Vimshottari.getVimDasaTableColumnMetaData());
        this.dasaTable = new AstrosoftTable((TableModel)this.dasaTableModel, TableStyle.SCROLL_SINGLE_ROW_SELECT);
        this.dasaTable.getTableHeader().setFont(font2);
        this.dasaTable.getSelectionModel().setLeadSelectionIndex(-1);
        this.dasaTitle = new TitleLabel(DisplayStrings.VIM_DASA_STR);
        JPanel jPanel = new JPanel();
        jPanel.add(new TitledTable(this.dasaTitle, this.dasaTable, tableSize));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jSplitPane.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jSplitPane, "Center");
        this.setVisible(true);
        TreePath treePath = vimshottari.getCurrentDasaPath();
        jTree.setSelectionPath(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
        this.nodeSelected(defaultMutableTreeNode, treePath);
        jTree.addTreeSelectionListener(new DasaTreeListener(this));
    }

    @Override
    public void nodeSelected(DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath) {
        Dasa dasa = (Dasa)defaultMutableTreeNode.getUserObject();
        boolean bl = defaultMutableTreeNode.isRoot();
        if (defaultMutableTreeNode.isLeaf()) {
            this.updateDasaTable(dasa.getParent(), bl);
        } else {
            this.updateDasaTable(dasa, bl);
        }
        if (!bl && defaultMutableTreeNode.isLeaf()) {
            this.setRowSelected(defaultMutableTreeNode.getParent(), defaultMutableTreeNode);
        }
        String string = bl ? DisplayStrings.VIM_DASA_STR.toString() : treePath.getPathComponent(1).toString() + " " + DisplayStrings.DASA_STR.toString();
        this.dasaTitle.setText(string);
    }

    private void setRowSelected(TreeNode treeNode, TreeNode treeNode2) {
        int n = treeNode.getIndex(treeNode2);
        this.dasaTable.getSelectionModel().setLeadSelectionIndex(n);
    }

    private void updateDasaTable(Dasa dasa, boolean bl) {
        TableData<Dasa> tableData = null;
        tableData = bl || dasa == null ? this.v.getVimDasaTableData() : this.v.getVimDasaTableData(dasa);
        if (tableData.getRowCount() > 0) {
            this.dasaTableModel.updateData(tableData);
        }
    }
}

