/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.view;

import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.ui.comp.VargaChartPanel;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.AstrosoftView;
import app.astrosoft.xps.yoga.YogaResults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class YogaCombinationsView
extends AstrosoftView {
    private static final Logger log = Logger.getLogger(YogaCombinationsView.class.getName());
    private static final Dimension viewSize = new Dimension(790, 470);
    private static final Dimension yogaSize = new Dimension((int)((double)YogaCombinationsView.viewSize.width * 0.2), YogaCombinationsView.viewSize.height);
    private static final Dimension chartSize = new Dimension((int)((double)YogaCombinationsView.viewSize.width * 0.5), (int)((double)YogaCombinationsView.viewSize.height * 0.6));
    private static final Point viewLoc = new Point(0, 0);
    private JPanel chartPanel;
    private PlanetaryInfo planetaryInfo;
    private YogaResults yogaResults;
    private JEditorPane editorPane;
    private JList yogaList;

    public YogaCombinationsView(String string, YogaResults yogaResults, PlanetaryInfo planetaryInfo) {
        super(viewSize, viewLoc);
        this.planetaryInfo = planetaryInfo;
        this.yogaResults = yogaResults;
        JPanel jPanel = new JPanel();
        this.yogaList = new JList<Object>(yogaResults.getYogas().toArray());
        this.yogaList.setFont(UIUtil.getFont("Tahoma", 0, 11));
        this.yogaList.setSelectionMode(0);
        this.yogaList.setSelectedIndex(0);
        jPanel.add(this.yogaList);
        jPanel.setPreferredSize(yogaSize);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.createResultPane());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.yogaList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                YogaCombinationsView.this.yogaChanged((YogaResults.Result)YogaCombinationsView.this.yogaList.getSelectedValue());
            }
        });
        this.add((Component)jSplitPane, "Center");
    }

    private void yogaChanged(YogaResults.Result result) {
        this.editorPane.setText(result.getYoga().getHtmlString());
    }

    private JSplitPane createResultPane() {
        this.chartPanel = new JPanel(new BorderLayout());
        this.chartPanel.add((Component)new VargaChartPanel(this.planetaryInfo, chartSize), "Center");
        JSplitPane jSplitPane = new JSplitPane(0, this.chartPanel, this.createYogaDetailPane());
        this.chartPanel.setBorder(BorderFactory.createEtchedBorder());
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        return jSplitPane;
    }

    private Component createYogaDetailPane() {
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        this.yogaChanged((YogaResults.Result)this.yogaList.getSelectedValue());
        this.editorPane.setBorder(BorderFactory.createEtchedBorder());
        return this.editorPane;
    }
}

