/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.window;

import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.window.DefaultWindowLabelModel;
import app.astrosoft.ui.window.WindowLabelModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;

public class AstrosoftWindow
extends JWindow {
    private Color windowBgClr = UIConsts.LIGHT_YELLOW;
    private Color windowTextClr = UIConsts.MEROON_RED;
    private Font windowTextFont = new Font("Tahoma", 1, 10);
    private WindowLabelModel model;
    private Component renderer;

    public AstrosoftWindow() {
        this.renderer = new JLabel();
        this.model = new DefaultWindowLabelModel("default");
    }

    public AstrosoftWindow(Component component) {
        this.renderer = component;
    }

    public AstrosoftWindow(WindowLabelModel windowLabelModel) {
        this.renderer = new JLabel();
        this.model = windowLabelModel;
        this.setSize(70, 20);
    }

    public AstrosoftWindow(WindowLabelModel windowLabelModel, Color color, Font font, Color color2) {
        this(windowLabelModel);
        this.windowTextClr = color;
        this.windowTextFont = font;
        this.windowBgClr = color2;
    }

    public AstrosoftWindow(Color color) {
        this.windowTextClr = color;
    }

    public AstrosoftWindow(Component component, Color color, Font font, Color color2) {
        this(component);
        this.windowTextClr = color;
        this.windowTextFont = font;
        this.windowBgClr = color2;
    }

    public void setRenderer(Component component) {
        this.renderer = component;
    }

    public void setModel(WindowLabelModel windowLabelModel) {
        this.renderer = new JLabel();
        this.model = windowLabelModel;
    }

    public void show(Point point) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(LineBorder.createGrayLineBorder());
        jPanel.setBackground(this.windowBgClr);
        this.renderer.setFont(this.windowTextFont);
        this.renderer.setForeground(this.windowTextClr);
        if (this.renderer instanceof JLabel) {
            JLabel jLabel = (JLabel)this.renderer;
            jLabel.setText(this.model.getText());
        }
        jPanel.add(this.renderer);
        this.add(jPanel);
        this.setLocation(point);
        this.setVisible(true);
        this.pack();
    }
}

