/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.beans.Place;
import app.astrosoft.consts.Alphabet;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.util.Mod;
import com.web_tomorrow.utils.suntimes.SunTimes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import swisseph.SweDate;

public class AstroUtil {
    private static final Logger log = Logger.getLogger(AstroUtil.class.getName());
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d yyyy");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("MMM d yyyy, hh:mm:ss a");

    public static String dms(double d) {
        String string = new String();
        if (d < 0.0) {
            d = Math.abs(d);
            string = string + "-";
        }
        int[] nArray = AstroUtil.int_dms(d);
        string = string + AstroUtil.threeDigit(nArray[0]) + " : " + AstroUtil.twoDigit(nArray[1]) + " : " + AstroUtil.twoDigit(nArray[2]);
        return string;
    }

    public static double decimal(int n, int n2, int n3) {
        double d = (n * 60 + n2) * 60 + n3;
        double d2 = d / 3600.0;
        return d2;
    }

    public static double toDouble(String string) {
        return AstroUtil.toDouble(string, ":");
    }

    public static double toDouble(String string, String string2) {
        String[] stringArray = string.split(string2);
        if (stringArray.length == 2) {
            return AstroUtil.decimal(stringArray[0], stringArray[1], "0");
        }
        if (stringArray.length == 3) {
            return AstroUtil.decimal(stringArray[0], stringArray[1], stringArray[2]);
        }
        throw new IllegalArgumentException("Invalid Format deg:mm:sec " + string);
    }

    private static double decimal(String string, String string2, String string3) {
        return AstroUtil.decimal(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public static String todegmin(double d, String string, boolean bl) {
        String string2 = new String();
        if (!bl && d < 0.0) {
            string2 = string2 + "-";
        }
        int[] nArray = AstroUtil.int_dms(d);
        string2 = string2 + AstroUtil.twoDigit(nArray[0]) + string + AstroUtil.twoDigit(nArray[1]);
        return string2;
    }

    public static String todegmin(double d, String string) {
        return AstroUtil.todegmin(d, string, false);
    }

    public static String todegminsec(double d, String string, boolean bl) {
        String string2 = new String();
        if (!bl && d < 0.0) {
            string2 = string2 + "-";
        }
        int[] nArray = AstroUtil.int_dms(d);
        string2 = string2 + AstroUtil.twoDigit(nArray[0]) + string + AstroUtil.twoDigit(nArray[1]) + string + AstroUtil.twoDigit(nArray[2]);
        return string2;
    }

    public static String todegminsec(double d, String string) {
        return AstroUtil.todegminsec(d, string, false);
    }

    public static String twoDigit(int n) {
        String string = new String();
        string = n < 10 ? "0" + String.valueOf(n) : String.valueOf(n);
        return string;
    }

    public static String threeDigit(int n) {
        String string = new String();
        string = n < 10 ? "00" + String.valueOf(n) : (n < 100 ? "0" + String.valueOf(n) : String.valueOf(n));
        return string;
    }

    public static double endTime(double d, double d2) {
        double d3 = 24.0 * d2 / d;
        return d3;
    }

    public static String panFormat(double d) {
        return AstroUtil.todegmin(d, ":");
    }

    public static double getSunRise(int n, int n2, int n3, double d, double d2, double d3) {
        Object object;
        double d4 = 0.0;
        try {
            object = SunTimes.getSunriseTimeUTC((int)n, (int)n2, (int)n3, (double)d, (double)d2, (double)90.83333333333333);
            d4 = AstroUtil.decimal(object.getHour(), object.getMinute(), object.getSecond()) + d3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new Mod(24);
        return ((Mod)object).correct(d4);
    }

    public static double getSunSet(int n, int n2, int n3, double d, double d2, double d3) {
        Object object;
        double d4 = 0.0;
        try {
            object = SunTimes.getSunsetTimeUTC((int)n, (int)n2, (int)n3, (double)d, (double)d2, (double)90.83333333333333);
            d4 = AstroUtil.decimal(object.getHour(), object.getMinute(), object.getSecond()) + d3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new Mod(24);
        return ((Mod)object).correct(d4);
    }

    public static double getSunRise(Calendar calendar, Place place) {
        return AstroUtil.getSunRise(calendar.get(1), calendar.get(2) + 1, calendar.get(5), place.longitude(), place.latitude(), place.timeZone());
    }

    public static double getSunSet(Calendar calendar, Place place) {
        return AstroUtil.getSunSet(calendar.get(1), calendar.get(2) + 1, calendar.get(5), place.longitude(), place.latitude(), place.timeZone());
    }

    public static String timeFormat(double d, boolean bl) {
        String string = new String();
        String string2 = new String();
        if (d == 0.0) {
            d = 12.0;
            string2 = "AM";
        } else if (d < 12.0) {
            string2 = "AM";
        } else if (d > 12.0) {
            string2 = "PM";
            d -= 12.0;
        }
        string = bl ? AstroUtil.todegminsec(d, ":") : AstroUtil.todegmin(d, ":");
        string = string + " " + string2;
        return string;
    }

    public static String timeFormat(double d) {
        return AstroUtil.timeFormat(d, false);
    }

    public static double incJulDate(double d, int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(SweDate.getDate((double)d));
        gregorianCalendar.add(1, n3);
        gregorianCalendar.add(2, n2);
        gregorianCalendar.add(5, n);
        SweDate sweDate = new SweDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), AstroUtil.decimal(gregorianCalendar.get(10), gregorianCalendar.get(12), gregorianCalendar.get(13)));
        return sweDate.getJulDay();
    }

    public static int[] int_dms(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        int n2 = (int)d2;
        int n3 = (int)((d2 - (double)n2) * 60.0);
        return new int[]{n, n2, n3};
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static String formatDateTime(Date date) {
        return dateTimeFormat.format(date);
    }

    public static Date parseDateTime(String string) {
        try {
            return dateTimeFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static double dateToDecimalYear(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(6);
        double d = gregorianCalendar.get(1);
        double d2 = gregorianCalendar.isLeapYear((int)d) ? (double)n / 366.0 : (double)n / 365.0;
        return d + d2;
    }

    public static Date decimalYearToDate(double d) {
        int n = (int)d;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 0, 1);
        double d2 = gregorianCalendar.isLeapYear(n) ? (d - (double)n) * 366.0 : (d - (double)n) * 365.0;
        gregorianCalendar.add(5, (int)d2);
        return gregorianCalendar.getTime();
    }

    public static Calendar getCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static Calendar getCalendar() {
        return AstroUtil.getCalendar(AstroSoft.today.getTime());
    }

    public static Date doubleTimeToDate(double d) {
        int[] nArray = AstroUtil.int_dms(d);
        Calendar calendar = AstroUtil.getCalendar();
        calendar.set(11, nArray[0]);
        calendar.set(12, nArray[1]);
        calendar.set(13, nArray[2]);
        return calendar.getTime();
    }

    public static double dateToTimeDouble(Date date) {
        Calendar calendar = AstroUtil.getCalendar(date);
        return AstroUtil.decimal(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static double nakEndPosition(double d) {
        double d2 = 13.333333333333334 - d % 13.333333333333334;
        return d + d2;
    }

    public static int computeNumeroVal(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (char c : cArray) {
            if (Character.isLetter(c)) {
                n += Alphabet.numeroValOf(c);
                continue;
            }
            if (!Character.isDigit(c)) continue;
            n += Integer.valueOf(Character.toString(c)).intValue();
        }
        return n;
    }

    public static int toNumeroNum(int n) {
        int n2 = n % 9;
        if (n2 == 0) {
            n2 = 9;
        }
        return n2;
    }

    public static Map<Rasi, Set<Planet>> calcPlanetInHouses(Map<Planet, Rasi> map) {
        EnumMap<Rasi, Set<Planet>> enumMap = new EnumMap<Rasi, Set<Planet>>(Rasi.class);
        for (Planet planet : map.keySet()) {
            Rasi rasi = map.get((Object)planet);
            if (enumMap.containsKey((Object)rasi)) {
                ((Set)enumMap.get((Object)rasi)).add(planet);
                continue;
            }
            enumMap.put(rasi, EnumSet.of(planet));
        }
        for (Rasi rasi : Rasi.values()) {
            if (enumMap.containsKey((Object)rasi)) continue;
            enumMap.put(rasi, EnumSet.noneOf(Planet.class));
        }
        return enumMap;
    }

    public static Map<Planet, Integer> calcPlanetLocation(Map<Planet, Rasi> map) {
        if (!map.containsKey((Object)Planet.Ascendant)) {
            throw new IllegalArgumentException("planetHouses is missing Ascendant");
        }
        Rasi rasi = map.get((Object)Planet.Ascendant);
        log.fine("Lagna " + (Object)((Object)rasi));
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        for (Planet planet : map.keySet()) {
            enumMap.put(planet, map.get((Object)planet).bhava(rasi));
        }
        return enumMap;
    }
}

