/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.util.AstroUtil;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AstrosoftTimeZone {
    String tzId;

    public AstrosoftTimeZone(String string) {
        this.tzId = string;
    }

    public double offset() {
        return AstrosoftTimeZone.offset(this.tzId);
    }

    public String id() {
        return this.tzId;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.tzId);
    }

    public static double offset(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        return (double)timeZone.getOffset(new GregorianCalendar(timeZone).getTimeInMillis()) / 3600000.0;
    }

    public String toString() {
        double d = this.offset();
        String string = d < 0.0 ? "-" : "+";
        return this.tzId + " (GMT " + string + AstroUtil.todegmin(this.offset(), ":", true) + ")";
    }

    public static AstrosoftTimeZone[] availableTimeZones() {
        String[] stringArray = TimeZone.getAvailableIDs();
        AstrosoftTimeZone[] astrosoftTimeZoneArray = new AstrosoftTimeZone[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            astrosoftTimeZoneArray[n++] = new AstrosoftTimeZone(string);
        }
        return astrosoftTimeZoneArray;
    }

    public boolean equals(Object object) {
        return this == object || this.tzId.equals(((AstrosoftTimeZone)object).id());
    }

    public int hashCode() {
        System.out.println("Hashcode tzId -> " + System.currentTimeMillis());
        return this.tzId.hashCode();
    }

    public static void main(String[] stringArray) {
        for (AstrosoftTimeZone astrosoftTimeZone : AstrosoftTimeZone.availableTimeZones()) {
            System.out.println(astrosoftTimeZone);
        }
    }
}

