/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;

public class ExcelReader {
    static final String[] states = new String[]{"Andaman", "Andhra Pradesh", "Arunachal Pradesh", "Assam", "Bihar", "Chandigarh", "Dadra", "Daman", "Delhi", "Goa", "Gujarat", "Haryana", "Himachal Pradesh", "Jammu and Kashmir", "Karnataka", "Kerala", "Lakshadweep", "Madhya Pradesh", "Maharashtra", "Manipur", "Meghalaya", "Mizoram", "Nagaland", "Orissa", "Pondicherry", "Punjab", "Rajasthan", "Sikkim", "Tamil Nadu", "Tripura", "Uttar Pradesh", "West Bengal"};
    Connection con = null;
    Statement st = null;
    ResultSet rs = null;
    PrintStream lats = null;
    FileOutputStream fos = null;

    public ExcelReader() throws Exception {
        File file = new File("LatitudeLongitudes.xml");
        this.fos = new FileOutputStream(file);
        this.lats = new PrintStream(this.fos);
    }

    private void writeSTag(String string) {
        this.lats.println("<" + string + ">");
    }

    private void writeSTag(String string, String string2, String string3) {
        this.lats.print("<" + string + " " + string2 + "=\"" + string3 + "\" >");
    }

    private void writeETag(String string) {
        this.lats.println("</" + string + ">");
    }

    private void writeTag(String string, String string2) {
        this.lats.println("<" + string + ">" + string2 + "</" + string + ">");
    }

    private void writeTag(String string, String string2, String string3, String string4) {
        this.lats.print("<" + string + " " + string3 + "=\"" + string4 + "\" >");
        this.lats.print(string2);
        this.lats.println("</" + string + ">");
    }

    public static void main(String[] stringArray) {
        try {
            ExcelReader excelReader = new ExcelReader();
            excelReader.writeSTag("world");
            excelReader.writeSTag("country", "name", "india");
            excelReader.readAllStates();
            excelReader.writeETag("country");
            excelReader.writeETag("world");
            excelReader.lats.close();
            excelReader.fos.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readAllStates() throws Exception {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        this.con = DriverManager.getConnection("jdbc:odbc:readxl");
        this.st = this.con.createStatement();
        for (int i = 0; i < states.length; ++i) {
            this.writeSTag("state", "name", states[i]);
            this.readState(states[i]);
            this.writeETag("state");
        }
        this.st.close();
        this.con.close();
    }

    private void readState(String string) throws Exception {
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        ResultSet resultSet = this.st.executeQuery("Select * from [" + string + "$] ");
        while (resultSet.next()) {
            this.writeSTag("city", "name", resultSet.getString(1));
            String string2 = resultSet.getString(2);
            Double d = Double.parseDouble(string2.substring(0, string2.indexOf("N")));
            this.writeTag("latitude", decimalFormat.format(d), "dir", "N");
            string2 = resultSet.getString(3);
            d = Double.parseDouble(string2.substring(0, string2.indexOf("E")));
            this.writeTag("longitude", decimalFormat.format(d), "dir", "E");
            this.writeETag("city");
        }
    }
}

