/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.exception.AstrosoftException;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.util.AstrosoftFileFilter;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public class FileOps {
    private static final Logger log = Logger.getLogger(FileOps.class.getName());

    public static String openFileDialog(Component component, FileDialogMode fileDialogMode, AstrosoftFileFilter astrosoftFileFilter) {
        AstrosoftPref astrosoftPref = AstroSoft.getPreferences();
        String string = astrosoftPref.getAstrosoftFilesDir();
        JFileChooser jFileChooser = new JFileChooser(string);
        UIUtil.setPanelBackground(jFileChooser, UIConsts.THEME_CLR);
        jFileChooser.setOpaque(true);
        jFileChooser.setFileFilter(astrosoftFileFilter);
        String string2 = null;
        if (fileDialogMode == FileDialogMode.OPEN) {
            string2 = FileOps.showFileOpenDialog(component, jFileChooser, astrosoftFileFilter);
        } else if (fileDialogMode == FileDialogMode.SAVE) {
            string2 = FileOps.showFileSaveDialog(component, jFileChooser, astrosoftFileFilter);
        }
        if (string2 != null) {
            astrosoftPref.setAstrosoftFilesDir(jFileChooser.getSelectedFile().getParentFile().getAbsolutePath() + File.separator);
        }
        return string2;
    }

    private static String showFileSaveDialog(Component component, JFileChooser jFileChooser, AstrosoftFileFilter astrosoftFileFilter) {
        int n;
        while ((n = jFileChooser.showSaveDialog(component)) == 0) {
            String string = FileOps.getSelectedFile(jFileChooser, astrosoftFileFilter);
            if (new File(string).exists()) {
                int n2 = OptionDialog.showDialog(string + " already exists. \n Do you want to overwrite it ? ", 3);
                if (n2 != 0) continue;
                return string;
            }
            return string;
        }
        return null;
    }

    private static String showFileOpenDialog(Component component, JFileChooser jFileChooser, AstrosoftFileFilter astrosoftFileFilter) {
        int n;
        while ((n = jFileChooser.showOpenDialog(component)) == 0) {
            String string = FileOps.getSelectedFile(jFileChooser, astrosoftFileFilter);
            if (!new File(string).exists()) {
                OptionDialog.showDialog(string + " does not exists. \n Please choose valid file. ", 0);
                continue;
            }
            return string;
        }
        return null;
    }

    private static String getSelectedFile(JFileChooser jFileChooser, AstrosoftFileFilter astrosoftFileFilter) {
        String string = jFileChooser.getSelectedFile().getAbsolutePath();
        String string2 = astrosoftFileFilter.getExtension();
        if (!string2.equals("*") && !string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    public static int getFromFile(String string, int n, int n2) {
        int n3 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(FileOps.class.getResourceAsStream("/resources/" + string)));
            int n4 = 1;
            while (n4++ < n) {
                bufferedReader.readLine();
            }
            String[] stringArray = new String[30];
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), ",");
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n5++] = stringTokenizer.nextToken();
            }
            n3 = Integer.parseInt(stringArray[n2 - 1]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void openDocument(String string) {
        Process process = null;
        String string2 = AstroSoft.getPreferences().getAcrobatExecutable();
        if (string2 == AstrosoftPref.defaultAcrobatExecutable) {
            throw new AstrosoftException("Acrobat Executable not initialized");
        }
        String[] stringArray = new String[]{string2, string};
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error executing command " + stringArray[0], exception);
            throw new AstrosoftException("Could not run acrobat, reason : " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
    }

    public static enum FileDialogMode {
        OPEN,
        SAVE;

    }
}

