/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.consts.AshtavargaName;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Kuta;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Paksha;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Thithi;
import app.astrosoft.consts.Varga;
import app.astrosoft.ui.AstroSoft;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Internalization {
    private static final Logger log = Logger.getLogger(Internalization.class.getName());
    public static String bundleName = "resources.AstrosoftBundle";
    private static Map<Language, ResourceBundle> bundles;
    private static Map<String, String> unsupportedMsgs;

    private static void loadBundles() {
        bundles = new EnumMap<Language, ResourceBundle>(Language.class);
        for (Language language : Language.values()) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, new Locale(language.isoCode()));
            bundles.put(language, resourceBundle);
        }
    }

    private static void addUnSupportedMsgs() {
        unsupportedMsgs.put(DisplayStrings.NAKPADA_STR.name(), "\u00bf\u00ec\u0084\u00ba\u00f2\u00be\u00a2\u00c3\u00f5 \u00c0\u00a1\u00be\u00f5");
        unsupportedMsgs.put(DisplayStrings.NAK_STR.name(), "\u00bf\u00ec\u0084\u00ba\u00f2\u00be\u00a2\u00c3\u00f5");
        unsupportedMsgs.put(DisplayStrings.THITHI_PAK_STR.name(), "\u00be\u00a2\u00be\u00a2/\u00c0\u00ec\u0084\u00f5");
        unsupportedMsgs.put(DisplayStrings.SARVAASHTAVARGA_STR.name(), "\u00ba\u00f7\u00c5\u00a1\u0089\u00bc\u00c5\u00f7\u00b8\u00f5");
        unsupportedMsgs.put(DisplayStrings.ASHTAVARGA_STR.name(), "\u00ab\u0089\u00bc\u00c5\u00f7\u00b8\u00f5");
        unsupportedMsgs.put(DisplayStrings.LONGITUDE_STR.name(), "\u00ab\u00ec\u0084\u00a1\u00f5\u00ba\u00f5");
        unsupportedMsgs.put(DisplayStrings.SID_TIME_STR.name(), "\u00bf\u00ec\u0084\u00ba\u00f2\u00be\u00a2\u00c3 \u00a7\u0086\u00a1\u00a8\u00c3");
        unsupportedMsgs.put(DisplayStrings.SUNRISE_SET_STR.name(), "\u00dd\u00c3\u00a2\u00c2 \u00af\u00be\u00c2\u00f5/\u00ab\u008a\u00be\u00f5");
        unsupportedMsgs.put(DisplayStrings.AYANAMSA_STR.name(), "\u00ab\u00c2\u00c9\u00a1\u00f5\u0085\u00f5");
        unsupportedMsgs.put(DisplayStrings.THITHI_PAK_STR.name(), "\u00be\u00a2\u00be\u00a2/\u00c0\u00ec\u0084\u00f5");
        unsupportedMsgs.put(DisplayStrings.PAKSHA_STR.name(), "\u00c0\u00ec\u0084\u00f5");
        unsupportedMsgs.put(DisplayStrings.SUNSET_STR.name(), "\u00dd\u00c3\u00a2\u00c2 \u00ab\u008a\u00be\u00f5");
        unsupportedMsgs.put(DisplayStrings.PLACE_STR.name(), "\u00fe\u00bc\u00f5");
        unsupportedMsgs.put(DisplayStrings.DOSHA_STR.name(), "\u00a7\u00be\u00a1\u0084\u00f5");
        unsupportedMsgs.put(Rasi.Mesha.name(), "\u00a7\u00c1\u0084\u00f5");
        unsupportedMsgs.put(Rasi.Vrishabha.name(), "\u00c3\u00a2\u0084\u00c0\u00f5");
        unsupportedMsgs.put(Rasi.Vrishabha.sym(), "\u00c3\u00a2\u0084");
        unsupportedMsgs.put(Nakshathra.Ashwini.name(), "\u00ab\u008a\u00c5\u00a2\u00c9\u00a2");
        unsupportedMsgs.put(Nakshathra.Mrigasira.name(), "\u00c1\u00a2\u00d5\u00b8\u0084\u00a2\u00c3\u00a2\u00bc\u00f5");
        unsupportedMsgs.put(Nakshathra.Hastam.name(), "\u0086\u008a\u00be\u00f5");
        unsupportedMsgs.put(Kuta.Vasya.name(), "\u00c5\u008a\u00c2\u00f5");
        unsupportedMsgs.put(Kuta.StreeDeergha.name(), "\u008a\u00be\u00a2\u00c3\u00a2\u00be\u00a3\u00f7\u00b8\u00f5");
        unsupportedMsgs.put(Varga.Hora.name(), "\u00a7\u0086\u00a1\u00a8\u00c3");
        unsupportedMsgs.put(AshtavargaName.AshtaVarga.name(), "\u00ab\u0089\u00bc\u00c5\u00f7\u00b8\u00f5");
        unsupportedMsgs.put(AshtavargaName.SarvaAshtavarga.name(), "\u00ba\u00f7\u00c5\u00a1\u0089\u00bc\u00c5\u00f7\u00b8\u00f5");
        unsupportedMsgs.put(AstrosoftTableColumn.JaiminiKaraka.name(), "\u00a6\u0083\u00f6\u00c1\u00a2\u00c9\u00a2 \u00b8\u00a1\u00c3\u00b8\u00f5");
        unsupportedMsgs.put(AstrosoftTableColumn.ResidentialStrength.name(), "\u00a6\u00c3\u0084\u00a2\u00a6\u00bc\u00fd\u00ba\u00a2\u00c2\u00f8");
        unsupportedMsgs.put(AstrosoftTableColumn.SthanaBala.name(), "\u008a\u00be\u00a1\u00bd");
        unsupportedMsgs.put(AstrosoftTableColumn.ChestaBala.name(), "\u00a7\u00ba\u0089\u00bc");
        unsupportedMsgs.put(AstrosoftTableColumn.IshtaBala.name(), "\u00fe\u0089\u00bc");
        unsupportedMsgs.put(AstrosoftTableColumn.KashtaBala.name(), "\u00b8\u0089\u00bc");
        unsupportedMsgs.put(AstrosoftTableColumn.OjaYugmarasyamsaBala.name(), "\u00b5\u0083\u00d4\u00ec\u00c1\u00c3\u0084\u00a1\u00f5\u00ba");
        unsupportedMsgs.put(AstrosoftTableColumn.SaptavargajaBala.name(), "\u00ba\u00f4\u00be\u00c5\u00f7\u0083");
        unsupportedMsgs.put(AstrosoftTableColumn.BhavaDrishtiBala.name(), "\u00c0\u00a1\u00c5 \u00be\u00a2\u00d5\u0089\u00ca");
        unsupportedMsgs.put(AstrosoftTableColumn.HoraBala.name(), "\u00a7\u0086\u00a1\u00c3");
        unsupportedMsgs.put(AstrosoftTableColumn.PakshaBala.name(), "\u00c0\u00ec\u0084");
        unsupportedMsgs.put(AstrosoftTableColumn.Beeja.name(), "\u00c0\u00a3\u0083\u00f5");
        unsupportedMsgs.put(AstrosoftTableColumn.Kshetra.name(), "\u00a7\u00b8\u0089\u00be\u00a2\u00c3\u00f5");
        unsupportedMsgs.put(Paksha.Krishna.name(), "\u00b8\u00a2\u00d5\u0089\u00bd");
        unsupportedMsgs.put(Thithi.Sashti.name(), "\u00ba\u0089\u00ca");
        unsupportedMsgs.put(Thithi.Ashtami.name(), "\u00ab\u0089\u00bc\u00c1\u00a2");
        unsupportedMsgs.put(Kuta.Rajju.name(), "\u00c3\u0088\u00d7");
        unsupportedMsgs.put("Vishakambha", "\u00c5\u00a2\u0089\u00b8\u00f5\u00c0\u00f5");
        unsupportedMsgs.put("Ayushman", "\u00ac\u00d4\u0089\u00c1\u00a1\u00fd");
        unsupportedMsgs.put("Harshana", "\u008b\u00f7\u0084\u00bd\u00f5");
        unsupportedMsgs.put("Vajra", "\u00c5\u0088\u00c3\u00f5");
        unsupportedMsgs.put("Shastiamsa", "\u00ba\u0089\u00ca\u00c2\u00a1\u00f5\u00ba\u00f5");
        unsupportedMsgs.put("Shashtamsa", "\u00ba\u00a1\u0089\u00bc\u00a1\u00f5\u00ba\u00f5");
        unsupportedMsgs.put("Ashtamsa", "\u00ab\u0089\u00bc\u00a1\u00f5\u00ba\u00f5");
    }

    public static String getString(Language language, String string) {
        boolean bl;
        String string2 = null;
        ResourceBundle resourceBundle = bundles.get((Object)language);
        log.finer("Bundle : " + resourceBundle.getLocale() + " Key : " + string);
        boolean bl2 = bl = !language.isEnglish();
        if (bl && (string2 = unsupportedMsgs.get(string)) != null) {
            return string2;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (bl) {
                string2 = bundles.get((Object)Language.ENGLISH).getString(string);
            }
            throw missingResourceException;
        }
        return string2;
    }

    public static String getString(String string) {
        return Internalization.getString(AstroSoft.getPreferences().getLanguage(), string);
    }

    public static String getString(Language language, Enum enum_) {
        return Internalization.getString(language, enum_.name());
    }

    public static String getString(DisplayFormat displayFormat, String ... stringArray) {
        switch (displayFormat) {
            default: {
                return Internalization.getString(stringArray[0]);
            }
            case SYMBOL: 
        }
        return Internalization.getString(stringArray[1]);
    }

    static {
        unsupportedMsgs = new HashMap<String, String>();
        Internalization.addUnSupportedMsgs();
        Internalization.loadBundles();
    }
}

