/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.beans.Interval;
import app.astrosoft.beans.MuhurthaBean;
import app.astrosoft.consts.MuhurthaRank;
import app.astrosoft.consts.Planet;
import app.astrosoft.util.SwissHelper;
import app.astrosoft.util.TransitHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import swisseph.SwissephException;

public class MuhurthaHelper {
    private static final Logger log = Logger.getLogger(MuhurthaHelper.class.getName());
    private EnumMap<MuhurthaRank, List<Interval>> tLongitudes;
    private TransitHelper transitHelper;

    public MuhurthaHelper(EnumMap<MuhurthaRank, List<Interval>> enumMap) {
        this.tLongitudes = enumMap;
        this.transitHelper = new SwissHelper().getTransitHelper(Planet.Moon);
    }

    public void setTransitLongitudes(EnumMap<MuhurthaRank, List<Interval>> enumMap) {
        this.tLongitudes = enumMap;
    }

    public List<MuhurthaBean> getTransists(Interval interval) {
        ArrayList<MuhurthaBean> arrayList = new ArrayList<MuhurthaBean>();
        for (MuhurthaRank muhurthaRank : this.tLongitudes.keySet()) {
            for (Interval interval2 : this.tLongitudes.get((Object)muhurthaRank)) {
                double d = interval.getStart();
                double d2 = interval.getEnd();
                while (d <= d2) {
                    try {
                        double d3 = this.transitHelper.getTransit(interval2.getStart(), d);
                        double d4 = this.transitHelper.getTransit(interval2.getEnd(), d3);
                        if (d3 <= d2) {
                            MuhurthaBean muhurthaBean = new MuhurthaBean(new Interval(d3, d4), interval2, muhurthaRank);
                            arrayList.add(muhurthaBean);
                        }
                        d = d4;
                    }
                    catch (SwissephException swissephException) {
                        log.log(Level.SEVERE, "Exception in calculating transists ", swissephException);
                    }
                }
            }
        }
        return arrayList;
    }
}

