/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.beans.Place;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.core.Panchang;
import app.astrosoft.core.PanchangList;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.MapTableRow;
import app.astrosoft.ui.table.TableData;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class PanExcelWriter {
    private static String PARENT_DIR = "c:/astrosoft/docs";
    private static DateFormat monFormat = new SimpleDateFormat("MMM_yyyy");
    private static DateFormat dateFormat = new SimpleDateFormat("dd EEE");

    public static void main(String[] stringArray) throws Exception {
        AstrosoftPref astrosoftPref = AstroSoft.getPreferences();
        astrosoftPref.setPlace(Place.getDefault());
        new PanExcelWriter(2009);
    }

    public PanExcelWriter(int n) throws Exception {
        WritableWorkbook writableWorkbook = null;
        PanchangList panchangList = new PanchangList(n);
        WritableSheet writableSheet = null;
        int n2 = 0;
        for (Panchang panchang : panchangList) {
            Calendar calendar = panchang.getDate();
            if (calendar.get(5) == 1) {
                writableWorkbook = Workbook.createWorkbook((File)new File(PARENT_DIR, "pan_" + monFormat.format(calendar.getTime()) + ".xls"));
                n2 = 0;
            }
            writableSheet = writableWorkbook.createSheet(dateFormat.format(calendar.getTime()), n2++);
            writableSheet.setColumnView(0, 10);
            writableSheet.setColumnView(1, 30);
            TableData<MapTableRow> tableData = panchang.getPanchangTableData();
            for (int i = 0; i < tableData.getRowCount(); ++i) {
                MapTableRow mapTableRow = tableData.getRow(i);
                String string = mapTableRow.getColumnData(AstrosoftTableColumn.Key).toString();
                if (string.equals("Auspicious Time") || string.equals("Rahu Kala") || string.equals("Yama Kanda")) continue;
                if (string.indexOf("End") >= 0) {
                    string = string.substring(0, string.length() - 9);
                }
                PanExcelWriter.writeRow(writableSheet, i, string, mapTableRow.getColumnData(AstrosoftTableColumn.Value).toString());
            }
            if (calendar.get(5) != calendar.getActualMaximum(5)) continue;
            writableWorkbook.write();
            writableWorkbook.close();
        }
    }

    private static void writeRow(WritableSheet writableSheet, int n, String string, String string2) throws RowsExceededException, WriteException {
        Label label = new Label(0, n, string);
        writableSheet.addCell((WritableCell)label);
        WritableCellFormat writableCellFormat = new WritableCellFormat(new WritableFont(WritableFont.createFont((String)"Tahoma"), 8));
        label.setCellFormat((CellFormat)writableCellFormat);
        label = new Label(1, n, string2);
        label.setCellFormat((CellFormat)writableCellFormat);
        writableSheet.addCell((WritableCell)label);
    }
}

