/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.beans.HousePosition;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.core.Ephemeris;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.util.TransitHelper;
import app.astrosoft.util.Utils;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import swisseph.DblObj;
import swisseph.SweDate;
import swisseph.SwissEph;

public class SwissHelper {
    public static final int HOUSE_SYSTEM = 80;
    public static final int HOUSE_FLAG = 65536;
    private SwissEph sw = new SwissEph();
    private SweDate sweDate;
    private EnumMap<Planet, Double> planetPos;
    private EnumMap<Planet, Boolean> isReverse;

    public SwissHelper(SweDate sweDate) {
        this();
        this.sweDate = sweDate;
    }

    public SwissHelper(int n, int n2, int n3, double d) {
        this(new SweDate(n, n2, n3, d));
    }

    public SwissHelper() {
        this.sw.swe_set_sid_mode(AstroSoft.getPreferences().getAyanamsa().ayaValue(), 0.0, 0.0);
    }

    public void setSweDate(SweDate sweDate) {
        this.sweDate = sweDate;
        this.calcPlanetaryPosition();
    }

    public void setAyanamsa(Ayanamsa ayanamsa) {
        this.sw.swe_set_sid_mode(ayanamsa.ayaValue(), 0.0, 0.0);
        this.calcPlanetaryPosition();
    }

    public void calcPlanetaryPosition() {
        this.calcPlanetaryPosition(Planet.allPlanets());
    }

    public void calcPlanetaryPosition(Set<Planet> set) {
        this.planetPos = new EnumMap(Planet.class);
        this.isReverse = new EnumMap(Planet.class);
        double[] dArray = new double[6];
        StringBuffer stringBuffer = new StringBuffer();
        for (Planet planet : set) {
            int n = this.sw.swe_calc_ut(this.sweDate.getJulDay(), planet.planetNo(), 65794, dArray, stringBuffer);
            this.planetPos.put(planet, dArray[0]);
            if (!(dArray[3] < 0.0) || Planet.isNode(planet)) continue;
            this.isReverse.put(planet, true);
        }
        Double d = this.planetPos.get((Object)Planet.Rahu);
        if (d != null) {
            double d2 = (d + 180.0) % 360.0;
            this.planetPos.put(Planet.Ketu, d2);
        }
    }

    public HousePosition calcHousePosition(double d, double d2) {
        double[] dArray = new double[10];
        double[] dArray2 = new double[13];
        this.sw.swe_houses(this.sweDate.getJulDay(), 65536, d2, d, 80, dArray2, dArray);
        HousePosition housePosition = new HousePosition(dArray2);
        housePosition.setSiderealTime(dArray[2] / 15.0);
        return housePosition;
    }

    public Rasi getAscendant(double d, double d2) {
        double[] dArray = new double[10];
        double[] dArray2 = new double[13];
        this.sw.swe_houses(this.sweDate.getJulDay(), 65536, d2, d, 80, dArray2, dArray);
        return Rasi.ofDeg(dArray2[1]);
    }

    public double getPlanetSpeed(Planet planet) {
        double[] dArray = new double[6];
        StringBuffer stringBuffer = new StringBuffer();
        this.sw.swe_calc_ut(this.sweDate.getJulDay(), planet.planetNo(), 65794, dArray, stringBuffer);
        return dArray[3];
    }

    public double getAyanamsa() {
        return this.sw.swe_get_ayanamsa_ut(this.sweDate.getJulDay());
    }

    public EnumMap<Planet, Double> getPlanetaryPosition() {
        if (this.planetPos == null) {
            this.calcPlanetaryPosition();
        }
        return this.planetPos;
    }

    public EnumMap<Planet, Boolean> getPlanetDirection() {
        if (this.isReverse == null) {
            this.calcPlanetaryPosition();
        }
        return this.isReverse;
    }

    public EnumMap<Planet, Double> getPlanetaryPosition(Set<Planet> set) {
        if (this.planetPos == null) {
            this.calcPlanetaryPosition(set);
        }
        return this.planetPos;
    }

    public EnumMap<Planet, Ephemeris.EphData> getEphData() {
        this.calcPlanetaryPosition();
        EnumMap<Planet, Ephemeris.EphData> enumMap = new EnumMap<Planet, Ephemeris.EphData>(Planet.class);
        for (Planet planet : this.planetPos.keySet()) {
            Ephemeris.EphData ephData = new Ephemeris.EphData(this.planetPos.get((Object)planet), this.isReverse.get((Object)planet));
            enumMap.put(planet, ephData);
        }
        return enumMap;
    }

    public SweDate getSweDate() {
        return this.sweDate;
    }

    public static double calcNatonnataBalaDeg(SweDate sweDate, double d) {
        SwissEph swissEph = new SwissEph();
        double d2 = sweDate.getJulDay() + sweDate.getDeltaT();
        DblObj dblObj = new DblObj();
        StringBuffer stringBuffer = new StringBuffer();
        int n = swissEph.swe_time_equ(d2, dblObj, stringBuffer);
        double d3 = dblObj.val * 24.0 * -1.0;
        double d4 = (d + d3) * 15.0;
        if (d4 > 180.0) {
            d4 = 360.0 - d4;
        }
        return d4;
    }

    public TransitHelper getTransitHelper(Planet planet) {
        return new TransitHelper(planet, this.sw);
    }

    public static void main(String[] stringArray) {
        SwissHelper swissHelper = new SwissHelper(1980, 12, 11, -3.7666666666666666);
        System.out.println(swissHelper.getPlanetaryPosition());
        HousePosition housePosition = swissHelper.calcHousePosition(77.73333333333333, 11.366666666666667);
        System.out.println(housePosition);
        for (Map.Entry<Planet, Double> entry : swissHelper.planetPos.entrySet()) {
            System.out.println((Object)((Object)entry.getKey()) + " -> " + (Object)((Object)housePosition.locateHouse(entry.getValue())));
        }
        System.out.println(Utils.sortMap(swissHelper.getPlanetaryPosition().entrySet(), true));
    }
}

