/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.consts.Planet;
import java.util.Date;
import swisseph.SweDate;
import swisseph.SwissEph;
import swisseph.TCPlanet;
import swisseph.TransitCalculator;

public class TransitHelper {
    private static final int TRANSIT_FLAG = 196608;
    private SwissEph sw;
    private TransitCalculator tc;

    TransitHelper(Planet planet, SwissEph swissEph) {
        this.sw = swissEph;
        this.tc = new TCPlanet(swissEph, planet.planetNo(), 196608, 0.0);
    }

    public double getTransit(double d, double d2, boolean bl) {
        this.tc.setOffset(d);
        return this.sw.getTransitUT(this.tc, d2, bl);
    }

    public double getTransit(double d, double d2) {
        return this.getTransit(d, d2, false);
    }

    public Date getTransitDate(double d, double d2) {
        return SweDate.getDate((double)this.getTransit(d, d2));
    }
}

