/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.util;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.ComparableEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Utils {
    public static <K, V extends Comparable<V>> List<ComparableEntry<K, V>> sortMap(Set<Map.Entry<K, V>> set, boolean bl, Comparator<ComparableEntry> comparator) {
        ArrayList<ComparableEntry<K, V>> arrayList = new ArrayList<ComparableEntry<K, V>>();
        for (Map.Entry<K, V> entry : set) {
            arrayList.add(new ComparableEntry<K, V>(entry));
        }
        return Utils.sortEntryList(arrayList, bl, comparator);
    }

    public static <K, V extends Comparable<V>> List<ComparableEntry<K, V>> sortMap(Set<Map.Entry<K, V>> set) {
        return Utils.sortMap(set, false, null);
    }

    public static <K, V extends Comparable<V>> List<ComparableEntry<K, V>> sortMap(Set<Map.Entry<K, V>> set, boolean bl) {
        return Utils.sortMap(set, bl, null);
    }

    public static <K, V extends Comparable<V>> List<ComparableEntry<K, V>> sortEntryList(List<ComparableEntry<K, V>> list, boolean bl, Comparator<ComparableEntry> comparator) {
        if (comparator == null) {
            if (bl) {
                Collections.sort(list, Collections.reverseOrder());
            } else {
                Collections.sort(list);
            }
        } else {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <K, V extends Comparable<V>> List<ComparableEntry<K, V>> sortEntryList(List<ComparableEntry<K, V>> list, boolean bl) {
        return Utils.sortEntryList(list, bl, null);
    }

    public static String printTableData(TableData<? extends TableRowData> tableData, ColumnMetaData columnMetaData) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < tableData.getRowCount(); ++i) {
            for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getColumns()) {
                stringBuffer.append(tableData.getRow(i).getColumnData(astrosoftTableColumn) + "\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String printTableData(Table table) {
        return Utils.printTableData(table.getTableData(), table.getColumnMetaData());
    }
}

